<div class="card card-body mt-4">
    <h3>Alternative Payment Methods</h3>
    <p>
        With alternative payment methods, customers across the globe can pay with their bank accounts,
        wallets, and other local payment methods. For example, a customer in the Netherlands might want
        to pay using iDEAL, which is used by more than half of consumers in the Netherlands for online purchases,
        whereas a customer in Belgium on the same website might want to pay using Bancontact, a popular payment method
        there.
    </p>
    <p class="mb-1">Integrate alternative payment methods so you can:</p>
    <ul class="ml-4 mb-4">
        <li class="mb-1">Present alternative payment methods that you want to offer.</li>
        <li class="mb-1">Customize the experience for collecting buyer information.</li>
        <li class="mb-1">Get your buyers, paying through an alternative payment method, checked out in as few steps as possible.</li>
    </ul>

    <form action="{{ route('admin.paypal.save-apm') }}" method="post">

        <table class="table table-striped">
            <thead>
            <tr>
                <th></th>
                <th>Payment method</th>
                <th>Payment type</th>
                <th>Payment flow</th>
                <th>Supported Countries</th>
                <th>Currencies</th>
                <th>Minimal order amount</th>
                <th>Refunds</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td>
                    <button type="submit"
                        name="bancontact"
                        class="btn btn-outline-{{ $config->get('bancontact') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('bancontact') == 1 ? '0' : '1' }}">
                        {{ $config->get('bancontact') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>Bancontact</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>Belgium</td>
                <td>EUR</td>
                <td>1 EUR</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="blik"
                        class="btn btn-outline-{{ $config->get('blik') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('blik') == 1 ? '0' : '1' }}">
                        {{ $config->get('blik') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>BLIK</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>Poland</td>
                <td>EUR</td>
                <td>1 PLN</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="eps"
                        class="btn btn-outline-{{ $config->get('eps') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('eps') == 1 ? '0' : '1' }}">
                        {{ $config->get('eps') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>eps</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>Austria</td>
                <td>EUR</td>
                <td>1 EUR</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="giropay"
                        class="btn btn-outline-{{ $config->get('giropay') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('giropay') == 1 ? '0' : '1' }}">
                        {{ $config->get('giropay') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>giropay</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>Germany</td>
                <td>EUR</td>
                <td>1 EUR</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="ideal"
                        class="btn btn-outline-{{ $config->get('ideal') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('ideal') == 1 ? '0' : '1' }}">
                        {{ $config->get('ideal') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>iDEAL</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>Netherlands</td>
                <td>EUR</td>
                <td>0.01 EUR</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="mybank"
                        class="btn btn-outline-{{ $config->get('mybank') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('mybank') == 1 ? '0' : '1' }}">
                        {{ $config->get('mybank') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>MyBank</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>Italy</td>
                <td>EUR</td>
                <td>N/A</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="pay_upon_invoice"
                        class="btn btn-outline-{{ $config->get('pay_upon_invoice') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('pay_upon_invoice') == 1 ? '0' : '1' }}">
                        {{ $config->get('pay_upon_invoice') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>Pay Upon Invoice</td>
                <td>deferred payment</td>
                <td>direct</td>
                <td>Germany</td>
                <td>EUR</td>
                <td>5 EUR</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="przelewy24"
                        class="btn btn-outline-{{ $config->get('przelewy24') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('przelewy24') == 1 ? '0' : '1' }}">
                        {{ $config->get('przelewy24') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>Przelewy24</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>Poland</td>
                <td>
                    EUR<br/>
                    PLN
                </td>
                <td>1 PLN</td>
                <td>180 days</td>
            </tr>
            <tr>
                <td>
                    <button type="submit"
                        name="sofort"
                        class="btn btn-outline-{{ $config->get('sofort') == 1 ? 'danger' : 'primary' }}"
                        value="{{ $config->get('sofort') == 1 ? '0' : '1' }}">
                        {{ $config->get('sofort') == 1 ? 'Disable' : 'Enable' }}
                    </button>
                </td>
                <td>SOFORT</td>
                <td>bank redirect</td>
                <td>redirect</td>
                <td>
                    Austria<br/>
                    Belgium<br/>
                    Germany<br/>
                    Spain<br/>
                    Italy<br/>
                    Netherlands<br/>
                    United Kingdom
                </td>
                <td>
                    EUR<br/>
                    GBP (GB only)
                </td>
                <td>1 EUR</td>
                <td>180 days</td>
            </tr>
            </tbody>
        </table>
    </form>
</div>