<?php

use Illuminate\Routing\Router;
use Mtc\PayPalPayments\Http\Controllers\PayPalConfigController;
use Mtc\PayPalPayments\Http\Controllers\PayPalPaymentController;
use Mtc\PayPalPayments\Http\Controllers\PayPalWebhookController;

/** @var Router $router */
$router->group([
    'prefix' => '/admin',
    'as' => 'admin.',
    'middleware' => [
        'auth'
    ]
], function (Router $router) {
    $router->get('settings/paypal/onboarded', [PayPalConfigController::class, 'store'])->name('paypal.referral-onboarded');
    $router->put('settings/paypal/disconnect', [PayPalConfigController::class, 'disconnect'])->name('paypal.disconnect');
    $router->get('settings/paypal/refresh-consent', [PayPalConfigController::class, 'refreshConsent'])->name('paypal.refresh-consent');
    $router->get('settings/paypal/refresh', [PayPalConfigController::class, 'refresh'])->name('paypal.refresh');
    $router->post('settings/paypal/toggle-ppcp', [PayPalConfigController::class, 'togglePPCP'])->name('paypal.toggle-ppcp');
    $router->post('settings/paypal/save-3dsec', [PayPalConfigController::class, 'save3DSec'])->name('paypal.save-3dsec');
    $router->post('settings/paypal/toggle-3dsec', [PayPalConfigController::class, 'toggle3DSec'])->name('paypal.toggle-3dsec');
    $router->post('settings/paypal/save-customization', [PayPalConfigController::class, 'customization'])->name('paypal.save-customization');
    $router->post('settings/paypal/create-consent', [PayPalConfigController::class, 'createConsent']);
    $router->resource('settings/paypal', PayPalConfigController::class)->only([ 'index', 'store' ]);
});

$router->post('paypal/webhooks', [PayPalWebhookController::class, 'webhooks'])->name('paypal-service-webhook');

$router->post('checkout/paypal-payments/{invoice}/create', [PayPalPaymentController::class, 'create'])->name('paypal.create');
$router->put('checkout/paypal-payments/{invoice}/approve', [PayPalPaymentController::class, 'approve'])->name('paypal.approve');
$router->put('checkout/paypal-payments/{invoice}/capture', [PayPalPaymentController::class, 'capture'])->name('paypal.capture');
