<?php

namespace Mtc\PayPalPayments\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Core\Admin\Menu;

class PayPalMenuSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $shop_menu = Menu::query()
            ->firstOrCreate(
                ['title' => 'Sales'],
                ['icon' => 'fas fa-shopping-cart']
            );

        $menu_data = [
            'title' => 'PayPal Settings',
            'path' => '/admin/settings/paypal',
            'activePath' => '/admin/settings/paypal',
            'constant' => '',
            'order' => 99,
        ];

        $child = $shop_menu->children()->create($menu_data);
        Menu::grantMenuPermissionToRole($child, ['Administrator']);
    }
}
