<div class="card card-body mt-4">
    <h3>Card Processing</h3>

    <form action="{{ route('admin.paypal.toggle-ppcp') }}" method="post">
        <button type="submit" class="btn btn-outline-primary">
            {{ $config->get('PPCP_ENABLED') ? 'Disable Card Processing' : 'Enable Card Processing' }}
        </button>
    </form>

    @if($config->get('PPCP_ENABLED'))
        <h3>3D Secure</h3>
        <p>
            3D Secure enables you to authenticate card holders through card issuers.<br />
            It reduces the likelihood of fraud when you use supported cards and improves transaction performance.<br />
            A successful 3D Secure authentication can shift liability for chargebacks due to fraud from you to the card
            issuer.
        </p>

        <form action="{{ route('admin.paypal.toggle-3dsec') }}" method="post">
            <button type="submit" class="btn btn-outline-primary">
                {{ $config->get('3DSEC_ENABLED') ? 'Disable 3D Secure' : 'Enable 3D Secure' }}
            </button>
        </form>

        @if($config->get('3DSEC_ENABLED'))

            <p>
                3D Secure authentication is performed only if the card is enrolled for the service.<br/>
                In scenarios where the 3D Secure authentication hasn't been successful, you have the option to complete
                the payment at your own risk, meaning that you, as the merchant, will be liable in case of a chargeback
            </p>
            <form action="{{ route('admin.paypal.save-3dsec') }}" method="post">
                <table class="table table-striped">
                    <thead>
                    <tr>
                        <th class="text-center">Enrollment Status</th>
                        <th class="text-center">Authentication Result</th>
                        <th class="text-center">Liability Shift</th>
                        <th class="text-center">Action</th>
                        <th class="text-center">Recommended Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center">Successful authentication.</td>
                        <td class="text-center">Liability might shift to the card issuer.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[yyp]">
                                <option value="accept" {{ $config->get('3DSEC_ypp') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_ypp') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">Continue with authorization</td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center">Failed authentication.</td>
                        <td class="text-center">Liability is with the merchant.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[ynn]">
                                <option value="accept" {{ $config->get('3DSEC_ynn') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_ynn') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">Do not continue with authorization</td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center">Rejected authentication</td>
                        <td class="text-center">Liability is with the merchant.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[yrn]">
                                <option value="accept" {{ $config->get('3DSEC_yrn') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_yrn') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">Do not continue with authorization</td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center">Attempted authentication</td>
                        <td class="text-center">Liability might shift to the card issuer.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[yap]">
                                <option value="accept" {{ $config->get('3DSEC_yap') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_yap') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">Continue with authorization</td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center">Unable to complete authentication</td>
                        <td class="text-center">The authentication system is not available.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[yuu]">
                                <option value="accept" {{ $config->get('3DSEC_yuu') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_yuu') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">
                            Do not continue with authorization.
                            Request cardholder to retry.
                        </td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center">Unable to complete authentication</td>
                        <td class="text-center">Liability is with the merchant.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[yun]">
                                <option value="accept" {{ $config->get('3DSEC_yun') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_yun') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">
                            Do not continue with authorization.
                            Request cardholder to retry.
                        </td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center">Challenge required for authentication</td>
                        <td class="text-center">The authentication system is not available.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[ycu]">
                                <option value="accept" {{ $config->get('3DSEC_ycu') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_ycu') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">
                            Do not continue with authorization.
                            Request cardholder to retry.
                        </td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are ready to complete a 3D Secure
                            authentication
                        </td>
                        <td class="text-center"></td>
                        <td class="text-center">Liability is with the merchant.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[y-n]">
                                <option value="accept" {{ $config->get('3DSEC_y-n') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_y-n') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">
                            Do not continue with authorization.
                            Request cardholder to retry.
                        </td>
                    </tr>
                    <tr>
                        <td class="text-center">Card type and issuing bank are not ready to complete a 3D Secure
                            authentication.
                        </td>
                        <td class="text-center"></td>
                        <td class="text-center">Liability is with the merchant.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[n-n]">
                                <option value="accept" {{ $config->get('3DSEC_n-n') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_n-n') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">Continue with authorization.</td>
                    </tr>
                    <tr>
                        <td class="text-center">System is unavailable at the time of the request.</td>
                        <td class="text-center"></td>
                        <td class="text-center">Liability is with the merchant.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[u-n]">
                                <option value="accept" {{ $config->get('3DSEC_u-n') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_u-n') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">Continue with authorization</td>
                    </tr>
                    <tr>
                        <td class="text-center">System is unavailable at the time of the request.</td>
                        <td class="text-center"></td>
                        <td class="text-center">The authentication system is not available.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[u-u]">
                                <option value="accept" {{ $config->get('3DSEC_u-u') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_u-u') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">
                            Do not continue with authorization.
                            Request cardholder to retry.
                        </td>
                    </tr>
                    <tr>
                        <td class="text-center">System has bypassed authentication.</td>
                        <td class="text-center"></td>
                        <td class="text-center">Liability is with the merchant.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[b-n]">
                                <option value="accept" {{ $config->get('3DSEC_b-n') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_b-n') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">
                            Continue with authorization.
                        </td>
                    </tr>
                    <tr>
                        <td class="text-center"></td>
                        <td class="text-center"></td>
                        <td class="text-center">The authentication system is not available.</td>
                        <td class="text-center">
                            <select name="3d_sec_actions[--u]">
                                <option value="accept" {{ $config->get('3DSEC_--u') === 'accept' ? 'selected' : '' }}>
                                    Accept Payment
                                </option>
                                <option value="decline" {{ $config->get('3DSEC_--u') === 'decline' ? 'selected' : '' }}>
                                    Decline Payment
                                </option>
                            </select>
                        </td>
                        <td class="text-center">
                            Do not continue with authorization.
                            Request cardholder to retry.
                        </td>
                    </tr>
                    </tbody>
                </table>
                <button type="submit" class="btn btn-outline-primary">
                    Save 3D Secure Settings
                </button>
                <button type="submit" name="reset_defaults" class="btn btn-outline-secondary">
                    Reset to Recommended Settings
                </button>
            </form>
        @endif
    @endif
</div>
