<?php

namespace Mtc\PayPalPayments;

use GuzzleHttp\Exception\ClientException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Checkout\Contracts\ExternalPaymentGateway;
use Mtc\Checkout\Contracts\HandlesRefunds;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\Contracts\PaymentGateway;
use Mtc\Checkout\Invoice\Payment;
use Mtc\Checkout\PaymentForm;
use Mtc\PayPalPayments\Services\PaymentService;

class PayPalPayLaterMessages implements ExternalPaymentGateway
{
    /**
     * @var PaymentService
     */
    protected $service;

    /**
     * @var PayPalSettings
     */
    protected $settings;

    public function __construct(PaymentService $service, PayPalSettings $settings)
    {
        $this->service = $service;
        $this->settings = $settings;
    }

    /**
     * @param InvoiceRepositoryContract $invoice
     * @param \Mtc\Checkout\Contracts\PayableContract $payable
     * @return bool
     */
    public function isApplicable(BasketRepositoryInterface $basket): bool
    {
        if (config('paypal_payments.enabled') === false || $this->settings->allowPayments() === false) {
            return false;
        }

        if ($basket->getCostTotalAttribute() <= config('paypal_payments.minimal_transaction_amount')) {
            return false;
        }

        if (empty($this->settings->get('API_CLIENT_ID')) || empty($this->settings->get('API_CLIENT_ID'))) {
            return false;
        }

        return $this->settings->get('pay_later') == 1;
    }

    /**
     * @param InvoiceRepositoryContract $invoice
     * @return string
     */
    public function getPaymentForm(BasketRepositoryInterface $basket): PaymentForm
    {
        return new PaymentForm(
            '<div data-pp-message :data-pp-amount="' . $basket->getCostTotalAttribute() . '"></div>',
            'template',
            [
                'express_checkout_label' => false,
            ]
        );
    }

    /**
     * Done via internal controller
     *
     * @param Request $request
     * @param InvoiceRepositoryContract $invoice
     * @return array
     */
    public function charge(Request $request, InvoiceRepositoryContract $invoice): array
    {
        return [];
    }
}
