<div class="card card-body">
    @if ($config->get('payments_receivable') == false)
        <strong class="text-danger">
            Attention: You currently cannot receive payments due to restriction on your PayPal account.
            Please reach out to PayPal Customer Support or connect to
            <a href="https://www.paypal.com/" target="_blank">https://www.paypal.com</a>
            for more information.
        </strong>
        <hr class="my-2"/>
    @endif

    @if ($config->get('primary_email_confirmed') == false)
        <strong class="text-danger my-2">
            Attention: Please confirm your email address on
            <a href="https://www.paypal.com/businessprofile/settings" target="_blank">
                https://www.paypal.com/businessprofile/settings
            </a>
            in order to receive payments! You currently cannot receive payments.
        </strong>
        <hr class="my-2"/>
    @endif
    @if ($config->needsVetting())
        <strong class="text-danger my-2">
            PayPal requires more information about your business on
            <a href="https://www.paypal.com/" target="_blank">paypal.com</a> to enable “Custom Card Fields”.
            Until then you are still offering all other PayPal payment methods to your customers.
        </strong>
        <hr class="my-2"/>
    @endif
    @if ($config->vettingReview())
        <strong class="text-danger my-2">
            PayPal is currently reviewing your information after which you’ll be notified of your eligibility
            for
            Custom Card Fields. Until then you are still offering all other PayPal payment methods to your
            customers.
        </strong>
        <hr class="my-2"/>
    @endif
    @if ($config->vettingDenied())
        <strong class="text-danger my-2">
            PayPal denied your application to use Custom Card Fields.
            You can retry in {{ $config->vettingRetryDate() }} on
            <a href="https://www.paypal.com/" target="_blank">paypal.com</a>.
            Until then you are still offering all other PayPal payment methods to your customers.
        </strong>
        <hr class="my-2"/>
    @endif
    @if ($config->limitWarning())
        <strong class="text-danger my-2">
            PayPal requires more information about your business on
            <a href="https://www.paypal.com/" target="_blank">paypal.com</a>
            to fully enable “Custom Card Fields” beyond a $500 receiving limitation.
            After reaching the $500 limit you will still be offering all other PayPal
            payment methods except "Custom Card Fields" to your customers.
        </strong>
        <hr class="my-2"/>
    @endif
    @if ($config->overLimitWarning())
        <strong class="text-danger my-2">
            PayPal requires more information about your business on
            <a href="https://www.paypal.com/" target="_blank">paypal.com</a>
            to fully enable “Custom Card Fields” beyond a $500 receiving limitation.
            You already surpassed this $500 limitation for "Custom Card Fields" transactions
            hence won't be able to process more "Custom Card Fields" transactions
            but are still offering all other PayPal payment methods to your customers.
        </strong>
        <hr class="my-2"/>
    @endif

    <p>
        Your PayPal account has been linked.
    </p>
    <p>
        <strong>Merchant ID:</strong>
        {{ $config->get('merchant_id') }}
    </p>
    <p>
        <strong>Primary PayPal account email:</strong>
        {{ $config->get('primary_email') }}
    </p>
    <p>
        <strong>Approved Scopes:</strong><br/>
        @foreach (collect(json_decode($config->get('scopes')), []) as $scope)
            {{ $scope }}<br/>
        @endforeach
    </p>
    <p>
        <strong>Able to receive payments:</strong>
        {{ $config->get('payments_receivable') ? 'Yes' : 'No' }}
    </p>
    <p>
        <strong>Primary email confirmed:</strong>
        {{ $config->get('primary_email_confirmed') ? 'Yes' : 'No' }}
    </p>
    <a href="{{ route('admin.paypal.refresh') }}">
        <i class="far fa-redo"></i> Reload Account Details
    </a>

</div>

@include('paypal::config.customization')
@if ($config->get('PPCP_CUSTOM_VETTING') === 'SUBSCRIBED')
    @include('paypal::config.cards')
@endif
@include('paypal::config.pay_later')
@include('paypal::config.alternative_payments')


<div class="card card-body mt-4">
    <h3 class="mt-4">Revoke account</h3>
    <form action="{{ route('admin.paypal.disconnect') }}"
            method="post"
            id="disconnectAccountForm">
        <button type="submit" class="alert"
                title="Disconnecting your PayPal account will prevent you from offering PayPal services and products on your website. Do you with to continue?"
                data-delete_id="disconnectAccountForm">
            <span class="text-danger">
                Disconnect PayPal account
            </span>
        </button>
        {{ csrf_field() }}
        {{ method_field('PUT') }}
    </form>
</div>