@extends('foundation::layouts.admin')

@section('title', 'PayPal Settings')

@section('content')
    <div class="container">
        <h1>PayPal Payment Settings</h1>

        @if (session()->has('success'))
            <div class="msg alert alert-success">{{ session('success') }}</div>
        @endif
        @if (session()->has('error'))
            <div class="msg alert alert-danger">{{ session('error') }}</div>
        @endif

        @includeWhen($config->hasAccess() === false, 'paypal::config.require_access')
        @includeWhen($config->hasAccess(), 'paypal::config.details')
    </div>
@endsection

@section('after_assets')
    <script>
        (function(d, s, id) {
            var js, ref = d.getElementsByTagName(s)[0];
            if (!d.getElementById(id)) {
                js = d.createElement(s);
                js.id = id;
                js.async = true;
                js.src = "https://www.paypal.com/webapps/merchantboarding/js/lib/lightbox/partner.js";
                ref.parentNode.insertBefore(js, ref);
            }
        }(document, "script", "paypal-js"));

    </script>
@endsection