<?php

namespace App\Console\Commands;

use Database\Seeders\DatabaseSeeder;
use Illuminate\Console\Command;


class DatabaseSeederCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'database:seed';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Runs all the seeders';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(): int
    {
        // Under no circumstance run this on a Live site.
        if (config('app.env') === 'production') {
            $this->error('This is production, mate!');
            return 0;
        }

        $seeder = new DatabaseSeeder();

        $this->info('Truncating DB tables...');
        $seeder->truncateTables();

        $this->info('Start seeding DB tables...');
        $seeder->run();
        $this->info('Seeding Complete!');
        return 0;
    }
}
