<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Core\Import\Magento;

class ImportCommand extends Command
{
    private $service;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import {type=ask} {--first-id=} {--last-id=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import data from Magento';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->service = new Magento($this);
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $type = $this->argument('type');
        $first_id = $this->option('first-id');
        $last_id = $this->option('last-id');

        if ($type === 'customers' || ($type === 'ask' && $this->confirm('Import Customers?', false))) {
            $this->service->customers($first_id, $last_id);
        }

        if ($type === 'categories' || ($type === 'ask' && $this->confirm('Import Categories?', false))) {
            $this->service->categories();
        }

        if ($type === 'products' || ($type === 'ask' && $this->confirm('Import Products?', false))) {
            $this->service->products($first_id, $last_id);
        }

        if ($type === 'orders' || ($type === 'ask' && $this->confirm('Import Orders?', true))) {
            $this->service->orders($first_id, $last_id);
        }

        if ($type === 'assessment_forms') {
            $this->service->assessment_forms();
        }

        if ($type === 'assessment_answers') {
            $this->service->assessment_answers($first_id, $last_id);
        }

        //$this->service->matchAssessmentToProducts();
    }
}
