<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AddScriptEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public string $script;

    const GLOBAL_KEY = 'plugin_scripts';

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(string $script)
    {
        $this->script = $script;
    }

}
