<?php

namespace App\Events;

use Basket;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BasketItemsLoadedEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var Basket $basket
     */
    protected Basket $basket;

    /**
     * @return mixed
     */
    public function getBasket(): Basket
    {
        return $this->basket;
    }

    /**
     * @param $basket
     */
    public function __construct(Basket $basket)
    {
        $this->basket = $basket;
    }
}
