<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\ViewErrorBag;
use Mtc\Core\Admin\User;
use Mtc\Modules\Members\Models\Member;

/**
 * Class Controller
 *
 * @package Mtc\Core\Http\Controllers
 */
class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    /**
     * Seo Data Array
     *
     * @var array
     */
    protected $seo_data = [];

    /**
     * Page Meta Data Array
     *
     * @var array
     */
    protected $page_meta = [];

    /**
     * Current user
     *
     * @var Member $member
     */
    protected $member;

    /**
     * Current admin user
     *
     * @var User $admin_user
     * @deprecated use \Illuminate\Support\Facades\Auth::user()
     */
    protected $admin_user;

    /**
     * callAction() is the method through which Laravel actually calls the method.
     * At this point we have everything loaded and ready for usage.
     * Extending this method allows "easy" modification of controller logic before and after
     * controller method is handled.
     * Constructor and destructor on the other hand are bad usages and should be discouraged
     * as at that point the pipeline has not run yet and aspects like route validation,
     * middlewares and session are not available.
     *
     * @param string $method
     * @param array $parameters
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function callAction($method, $parameters)
    {
        $this->initializeTwig();
        $this->adminDependencies();
        $this->setMessages();

        return parent::callAction($method, $parameters);
    }

    /**
     * Initialize seo information for the url
     */
    protected function initializeSeo()
    {
        var_dump(__method__);
        var_dump("Why do we need it here?");
        exit;

        $seo_admin = new \Seo();
        $this->seo_data = $seo_admin->getSeoData();
        $this->page_meta = app()->make('page_meta');
    }

    /**
     * Initialize Twig environment for controller
     */
    protected function initializeTwig()
    {
        app('twig')->addGlobal('self', request()->getRequestUri());
        $twig = app('twig');
        require_once base_path('core/admin/includes/header.inc.php');
    }

    /**
     * Set status messages from session.
     *
     * This method attached errors, old input and success/warning messages to twig
     */
    protected function setMessages()
    {
        if (session()->has('errors')) {
            $errors = session('errors') instanceof ViewErrorBag ? session('errors')->getMessages() : session('errors');
            app('twig')->addGlobal('errors', $errors);
            session()->forget('errors');
        }

        if (session()->has('input')) {
            app('twig')->addGlobal('old', session('input'));
            session()->forget('input');
        }

        if (session()->has('messages')) {
            $messages = session('messages.type') ? [ session('messages') ] : session('messages');
            app('twig')->addGlobal('messages', $messages);
            session()->forget('messages');
        }

        if (session()->has('success')) {
            app('twig')->addGlobal('success', session('success'));
        }

        if (session()->has('error')) {
            app('twig')->addGlobal('error', session('error'));
        }
    }

    /**
     * Add Message to session stack
     *
     * @param $type
     * @param $content
     * @deprecated Use session()->flash() instead
     */
    public static function flashMessage($type, $content)
    {
        session()->flash($type, $content);
    }

    /**
     * Load admin dependencies for controller
     */
    protected function adminDependencies()
    {
        $this->admin_user = User::query()->find($_SESSION['adminId']);
    }
}
