<?php

namespace App\Providers;

use App\TwigHelper;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Mtc\Shop\Category;
use Mtc\Shop\Item;
use Mtc\Shop\Item\Image;
use Mtc\Shop\Item\Size;
use Setting;

class AppServiceProvider extends ServiceProvider
{

    public function boot()
    {
        if (! defined('SITE_PATH')) {
            define('SITE_PATH', base_path());
        }

        require_once base_path('sites/sites.php');
        require_once base_path('sites/loader.php');
        require_once base_path('core/includes/settings.php');

        if (Schema::hasTable('settings')) {
            Setting::import();
            Setting::loadAndDefine();
        }

        if (php_sapi_name() === 'cli') {
            require_once SITE_PATH . '/shop/browse/classes/productfilter.class.php';
            require_once SITE_PATH . '/core/includes/twig.php';

            TwigHelper::addCustomFunctions();
        }

        Relation::morphMap([
            'item'          => Item::class,
            'item_size'     => Size::class,
            'category'      => Category::class,
            'item_image'    => Image::class,
        ]);

        if (config('app.debug')) {
            if (php_sapi_name() != "cli") {
                //$this->app->bind(ExceptionRenderer::class, WhoopsExceptionRenderer::class);
            }
        }
    }
}
