<?php

namespace App\Providers;

use App\Events\AddScriptEvent;
use App\Listeners\AddScriptListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        AddScriptEvent::class => [
            AddScriptListener::class,
        ]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        Event::listen('subscriptions.paymentFailed', function($subscription) {
            $template = 'emails/shop/payment_failed.twig';

            $body = app('twig')->render($template, [
                'order' => $subscription->getLatestFailedPayment(),
            ]);

            $customer_email_address = $subscription->member->email;
            $subject = 'Payment failed';

            email($customer_email_address, $subject, $body, [ 'queue' => true ]);
            email(config('site.shop_email'), $subject, $body, [ 'queue' => true ]);
        });
    }
}
