 function updateCms(files) {
    var data = {
        'files': files,
        'version': $("#version").val(),
        'git_path': $("#git_path").val()
    };
    $(".loader").show();
    $("p.error").hide();
    $.ajax({
        url: 'ajax/patching-update-current-system-version.php',
        type: 'POST',
        data: data,
        cache: false,
    })
    .done(function(data) {
        $(".loader").hide();
        $(".comparison-output").html("<p class='success msg'>System updated!"+data+"</p>");
        return false;
    })
    .fail(function(jqXHR, textStatus, errorThrown ) {
        $("p.error").html(textStatus);
        $("p.error").show();
        $(".loader").hide();
        return false;
    });
}

function getDiffBetweenCurrentSysAndVersion(instruction_path) {

    var data = {
        'version': $("#version").val(),
        'important_file_list_location': $("#important_file_list_location").val(),
        'current_sys_commit_hash': $("#version_number").val(),
        'git_path': $("#git_path").val(),
        'instruction_path' : instruction_path
    };

    $("p.error").hide();
    $.ajax({
        url: 'ajax/patching-compare-with-current-system-version.php',
        type: 'POST',
        dataType: 'json',
        data: data,
        cache: false
    })
    .done(function(response) {

        if ( response.success !== true && response.success !== "true" ) {
            $("p.error").html("error comparing files");
            $("p.error").show();
            $(".loader").hide();
            return;
        }

        $(".loader").hide();
        $(".replace-selected-files-with-new-btn-row").show();
        $(".comparison-output-row").show();
        $(".comparison-output").html(response.html);
        $(".cms-patching-module .comparison-output .issue a.open").click(function(event) {
            event.preventDefault();
            $(this).parent().parent().children('.compare').slideToggle(100);
            return false;
        });

        $("#check_all").on(
            "click",
            function () {
                if ( $(this).prop("checked")  ) {
                    $(".file-to-be-replaced").prop({"checked":true});
                } else {
                    $(".file-to-be-replaced").prop({"checked":false});
                }
            }
        );
    })
    .fail(function(jqXHR, textStatus, errorThrown ) {
        $("p.error").html(textStatus);
        $("p.error").show();
        $(".loader").hide();
    });
    return false;
}

function getInstructionOptions() {
    $("p.error").hide();

    var data = {
        'version': $("#version").val(),
    };

    $.ajax({
        url: 'ajax/get_instructions.php',
        type: 'POST',
        dataType: 'json',
        data: data,
        cache: false
    })
    .done(function(response) {
        if ( response.success !== true ) {
            $("p.error").html("error getting instruction options");
            $("p.error").show();
            $(".loader").hide();
            return;
        }
        $(".loader").hide();
        $(".compare-with-instructions-btn-row").show();
        $(".instructionsRow").html("<p>Please select the patch you'd like to run.</p>");
        $(".instructionsRow").append("<div class=\"instructions-output\"></div>");
        for (var i = 0; i < response.instructions.length; i++) {
            $(".instructionsRow div.instructions-output").append("<div class=\"entryRow\"><div class=\"fileName\"><input type=\"radio\" value=\""+response.instructions[i].path+"\" data-filename=\""+response.instructions[i].path+"\" name=\"instruction\" id=\"instruction["+response.instructions[i].path+"]\" class=\"\"><label for=\"instruction["+response.instructions[i].path+"]\">"+response.instructions[i].name+"</label></div><div class=\"desc\" style=\"display:none\">"+response.instructions[i].description+"</div></div>");
        }
        $(".cms-patching-module .instructions-output .entryRow label").click(function(event) {
            $(this).parent().parent().children('.desc').slideToggle(100);
        });
        $(".compare-with-instructions-btn").on("click",function(event){
            event.preventDefault();
            if ( $('input[name=instruction]:checked').length ) {
                $(".compare-with-instructions-btn-row").hide();
                $(".loader").show();
                $('input[name=instruction]').attr("disabled",true);
                getDiffBetweenCurrentSysAndVersion($('input[name=instruction]:checked').val());
            }
            return false;
        });
        $(".instructionsRow").show();
    })
    .fail(function(jqXHR, textStatus, errorThrown ) {
        $("p.error").html(textStatus);
        $("p.error").show();
        $(".loader").hide();
    });
    return false;

}