$(function(){

    $("#show_up_to_date_files").change(function(event) {
        $(".noIssue").toggle();
    });
    $("#show_files_out_of_date_or_changed").change(function(event) {
        $(".issue").toggle();
    });

    $(".download-latest-version").click(function(event) {
        if ( $(".bitbucket-details .username").val() !== "" || $(".bitbucket-details .password").val() !== "" ) {
            event.preventDefault();
            $(".download-latest-version").hide();
            $(".loader").show();
            var data = {
                'current_sys_commit_hash': $("#version_number").val(),
                'debug': $("#debug").val(),
                'git_path': $("#git_path").val(),
                'cms_repo': $("#cms_repo").val(),
                'cms_repo_branch': $("#cms_repo_branch").val(),
                'version': $("#version").val(),
                'username': $("#bitbucket_username").val(),
                'password': $("#bitbucket_password").val()
            };
            $(".download-latest-version").hide();
            $(".loader").show();
            $("p.error").hide();
            $.ajax({
                url: 'ajax/patching-download-cms-version.php',
                type: 'POST',
                dataType: 'html',
                data: data,
                cache: false,
            })
            .done(function(data) {
                if ( data === "true" ) {
                    $(".bitbucket-details").slideUp();
                    $(".diff-area").slideDown();
                    getInstructionOptions();
                } else {
                    $("p.error").show();
                    $(".download-latest-version").show();
                    $(".loader").hide();
                }
            })
            .fail(function(jqXHR, textStatus, errorThrown ) {
                $("p.error").show();
                $("p.error").html(textStatus);
                $(".download-latest-version").show();
                $(".loader").hide();
            });
        }
        return false;
    });

    $('.replace-selected-files-with-new').click(function(event) {
        event.preventDefault();
        var files_to_be_actioned = [];
        $.each($(".file-to-be-replaced"), function(index, val) {
            if ( $(this).is(':checked') ) {
                files_to_be_actioned.push(
                    {
                        'filename': $(this).attr("data-filename"),
                        'source': $(this).attr("data-source"),
                        'destination': $(this).attr("data-destination"),
                        'mode': $(this).attr("data-mode"),
                    }
                );
            }
        });
        updateCms(files_to_be_actioned);
        return false;
    });

});