<?php
$page_meta['title'] = "Patching Tool";
$cms_root_path = "../../";
require_once($cms_root_path."includes/compatibility_includer.php");
include( $core_root_path."admin/templates/adminheader.html.php" );

$cms_patching = CmsPatching::newInstance()
    ->loadInfo( $cms_root_path."admin/cms_patching/" )
    ->loadConfig( $cms_root_path."admin/cms_patching/config.json" )
    ->loadBackups( $cms_root_path."admin/cms_patching/backup/")
;

?>

<form action="" method="POST" enctype="multipart/form-data" class="style cms-patching-module">

 	<h1>cms2 Patching Tool</h1>

    <fieldset class="show">
        <h1><a class="show el">Current System Details <i class="fa fa-caret-right"></i></a></h1>

        <div class="row">
            <label>Update-able</label>
            <input type="text" readonly value="<?=$cms_patching->info['updateable']?>" />
        </div>

        <div class="row">
            <label>Current system version</label>
            <input type="text" readonly value="<?=$cms_patching->info['version_number']?>" />
        </div>

        <div class="row">
            <label>Initial version</label>
            <input type="text" readonly value="<?=$cms_patching->info['original_version']?>" />
        </div>

         <div class="row">
            <label for="update_log">Update log</label>
            <textarea readonly id="update_log" name="update_log"><?php
                for ($i=0; $i < count($cms_patching->info['update_log']); $i++) {
                    echo $cms_patching->info['update_log'][$i]."\n";
                }?></textarea>
        </div>

        <div class="row">
            <label for="system_noted_modified_files">Files out of sync</label>
            <textarea readonly id="system_noted_modified_files" name="system_noted_modified_files"><?php
                for ($i=0; $i < count($cms_patching->info['system_noted_modified_files']); $i++) {
                    echo $cms_patching->info['system_noted_modified_files'][$i]."\n";
                }?></textarea>
        </div>

          <div class="row">
            <label>&nbsp;</label>
            <a class="btn" href="check_current_sys_version.php" title="Check if in sync with version <?=$cms_patching->info['version_number']?>">Check if in sync with CMS version <?=$cms_patching->info['version_number']?></a>
        </div>


    </fieldset>
    <fieldset class="show">
        <h1><a class="show el">Developer Notes<i class="fa fa-caret-right"></i></a></h1>

        <div class="row">
            <label for="user_noted_modified_files">Files developers have changed. (separate with line breaks)</label>
            <textarea id="user_noted_modified_files" name="user_noted_modified_files"><?php
                for ($i=0; $i < count($cms_patching->info['user_noted_modified_files']); $i++) {
                    echo $cms_patching->info['user_noted_modified_files'][$i]."\n";
                }?></textarea>
        </div>

        <div class="row">
            <label for="notes">Custom developer notes</label>
            <textarea id="notes" name="notes"><?=$cms_patching->info['notes']?></textarea>
        </div>

        <div class="row">
            <label>&nbsp;</label>
            <a class="btn" href="update.php" title="Update CMS">Update Developer Info</a>
        </div>


    </fieldset>

     <fieldset class="show">
        <h1><a class="show el">Config<i class="fa fa-caret-right"></i></a></h1>

        <div class="row">
            <label>Server git path</label>
            <input type="text" value="<?=( isset($cms_patching->config['git_path']) ? $cms_patching->config['git_path'] : "" )?>" />
        </div>

        <div class="row">
            <label>System type</label>
            <input type="text" value="<?=( isset($cms_patching->config['sys_type']) ? $cms_patching->config['sys_type'] : "" )?>" />
        </div>

        <div class="row">
            <label>CMS repo</label>
            <input type="text" value="<?=( isset($cms_patching->config['cms_repo']) ? $cms_patching->config['cms_repo'] : "" )?>" />
        </div>

        <div class="row">
            <label>CMS repo branch</label>
            <input type="text" value="<?=( isset($cms_patching->config['cms_repo_branch']) ? $cms_patching->config['cms_repo_branch'] : "" )?>" />
        </div>

        <div class="row">
            <label>Repo important file list location</label>
            <input
                type="text"
                id="important_file_list_location"
                name="important_file_list_location"
                value="<?=( isset($cms_patching->config['important_file_list_location']) ? $cms_patching->config['important_file_list_location'] : "" )?>"
            />
        </div>


        <div class="row">
            <label>&nbsp;</label>
            <a class="btn" href="update.php" title="Update CMS">Update Config</a>
        </div>


    </fieldset>

    <fieldset class="show">
        <h1><a class="show el">Actions <i class="fa fa-caret-right"></i></a></h1>

        <div class="row">
            <label>&nbsp;</label>
            <a class="btn" href="update.php" title="Update CMS">Update CMS</a>
        </div>
    </fieldset>

    <fieldset class="show">
        <h1><a class="show el">Backups <i class="fa fa-caret-right"></i></a></h1>

        <table>
            <?php

            foreach ($cms_patching->backups as $key => $backup) {

                ?>
                <tr>
                    <td><?=$backup['folder_name']?></td>
                    <td><?=$backup['datetime']?></td>
                    <td>
                        <a href="#" title="Restore">
                            Restore
                        </a>
                    </td>
                </tr>
                <?php

            }

            ?>
        </table>

    </fieldset>

</form>

<?php

include($core_root_path .'admin/templates/adminfooter.html.php');