<?php
$page_meta['title'] = "Patching Tool";
$cms_root_path = "../../";
require_once($cms_root_path."includes/compatibility_includer.php");
include( $core_root_path."admin/templates/adminheader.html.php" );

$cms_patching = CmsPatching::newInstance()
    ->loadInfo( $cms_root_path."admin/cms_patching/" )
    ->loadConfig( $cms_root_path."admin/cms_patching/config.json" )
;

?>
<script type="text/javascript" src="js/functions.js"></script>
<script type="text/javascript" src="js/script.js"></script>
<link rel="stylesheet" type="text/css" href="css/style.css"/>

<p class="msg clearfix error hide" style="display:none">
    Something went wrong. Most probably bitbucket username and/or password is wrong ir git path should be changed to '/usr/local/bin/git' in cms_patching/config.json.
</p>

<form action="" method="POST" enctype="multipart/form-data" class="style cms-patching-module">

    <h1><a href="manage.php" title="Patching Tool">Patching Tool</a> / Update</h1>

    <fieldset class="show cms-info">
         <div class="row">
            <label>Current version (commit)</label>
            <input type="text" readonly name="version_number" id="version_number" value="<?=$cms_patching->info['version_number']?>" />
        </div>

        <div class="row">
            <label>Initial version (commit)</label>
            <input type="text" readonly name="original_version" id="original_version" value="<?=$cms_patching->info['original_version']?>" />
        </div>

        <div class="row">
            <label>Version (commit) to update from</label>
            <input type="text" name="version" id="version" value="latest" />
        </div>

        <div class="row">
            <label>Server git path</label>
            <input type="text" name="git_path" id="git_path" value="<?=( isset($cms_patching->config['git_path']) ? $cms_patching->config['git_path'] : "" )?>" />
        </div>

        <div class="row">
            <label>Repo</label>
            <input type="text" name="cms_repo" id="cms_repo" value="<?=( isset($cms_patching->config['cms_repo']) ? $cms_patching->config['cms_repo'] : "" )?>" />
        </div>

        <div class="row">
            <label>Repo branch</label>
            <input type="text" name="cms_repo_branch" id="cms_repo_branch" value="<?=( isset($cms_patching->config['cms_repo_branch']) ? $cms_patching->config['cms_repo_branch'] : "" )?>" />
        </div>

        <div class="row">
            <label>Debug</label>
            <input type="text" name="debug" id="debug" value="0" />
        </div>

    </fieldset>

    <fieldset class="show">
        <h1 class="clearfix">Bitbucket details</h1>

        <div class="row">
            <label>Bitbucket username</label>
            <input type="text" id="bitbucket_username" name="bitbucket_username" class="bitbucket_username"  required value="" />
        </div>

        <div class="row">
            <label>Bitbucket password</label>
            <input type="password" id="bitbucket_password" name="bitbucket_password" class="bitbucket_password" required value="" />
        </div>

        <div class="row">
            <label>&nbsp;</label>
            <input type="submit" class="download-latest-version" name="Continue" value="Continue" />
            <div class="loader dotsLoaderWraper" style="display:none"><div class="dotsLoader">Loading..</div></div>
        </div>

    </fieldset>

    <fieldset class="diff-area" style="display:none">
        <h1>Update</h1>

        <div class="row instructionsRow">
        </div>

        <div class="row compare-with-instructions-btn-row" style="">
            <a class="btn compare-with-instructions-btn" href="#" title="Continue">Continue</a>
        </div>

        <div class="row replace-selected-files-with-new-btn-row" style="display: none;">
            <a class="btn replace-selected-files-with-new" href="#" title="Continue">Continue</a>
            <label for="check_all" style="width:72px; margin-left: 30px">check all</label>
            <input id="check_all" type="checkbox" name="check_all" value="1" checked />
            <label for="show_up_to_date_files" style="width:150px; margin-left: 30px">show up to date files</label>
            <input id="show_up_to_date_files" type="checkbox" name="show_up_to_date_files" value="1" checked />
            <label for="show_files_out_of_date_or_changed" style="width:230px; margin-left: 30px">show files out of date or changed</label>
            <input id="show_files_out_of_date_or_changed" type="checkbox" name="show_files_out_of_date_or_changed" value="1" checked />
        </div>

        <div class="row comparison-output-row" style="display: none;">
            <div class="comparison-output">&nbsp;</div>
        </div>
    </fieldset>

</form>

<?php

include( $core_root_path."admin/templates/adminfooter.html.php" );
