<?php
$path = "../../../";

include($path . "includes/header.inc.php");

$constant_check_table = array(
	array("php" => "define('CMS_CONVERT_TEXT_INPUT_TO_HTML_ENTITIES', false);", "constant" => "CMS_CONVERT_TEXT_INPUT_TO_HTML_ENTITIES"),
	array("php" => "define('CMS_ALLOW_CLIENT_TO_EDIT_SLUGS', false);", "constant" => "CMS_ALLOW_CLIENT_TO_EDIT_SLUGS"),
	array("php" => "define('CMS_ALLOW_CLIENT_TO_EDIT_SEO', false);", "constant" => "CMS_ALLOW_CLIENT_TO_EDIT_SEO"),
	array("php" => "define('CMS_ALLOW_CLIENT_TO_CREATE_PAGES', false);", "constant" => "CMS_ALLOW_CLIENT_TO_CREATE_PAGES"),
	array("php" => "define('CMS_INCLUDE_DOMAIN_IN_PAGE_URL', false);", "constant" => "CMS_INCLUDE_DOMAIN_IN_PAGE_URL"),
	array("php" => "define('CMS_HTML_CACHE_404', true); // html cache 404 page. only update on the html delete", "constant" => "CMS_HTML_CACHE_404"),
	array("php" => "define('LISTING_CACHE', true);", "constant" => "LISTING_CACHE"),
	array("php" => "define('PHP_LIB', '/usr/local/bin/php');", "constant" => "PHP_LIB"),
	array("php" => "/**
 * cms2 mulilanguage feature
 * 
 * Add the following thos composer.json and run composer update
 * \"require\": {
 *      \"illuminate/database\": \"5.0.4\",
 *      \"gettext/gettext\": \"3.3\"
 * }
 * 
 */
define('CMS_MULTI_LANG', false); // enable/disable cms2 support for multilangauges
	define('CMS_MULTI_SWITCH_LABEL', 'code'); // Changes the language switch label in cm admin panel. (name/code)
	/**
	 * Restrict multilanguage for certan pages in the admin area 
	 * false    : no restrictions
	 * true     : see restrictions in CMS_MULTI_LANG_PAGE_IGNORE_JSON
	 */
	define('CMS_MULTI_LANG_PAGE_IGNORE', false); 
	/**
	 * [\"*\",\"!228/*\",\"!265\"] : ignore every page except 228 and its subpages and !265 (but ignore 265 subpages)
	 * [\"228/*\"] : ignore page 228 and its subpages
	 * [\"228\"] : ignore only page 228
	 * [\"228\",\"351\", \"322\"] : ignore only page 228, 351 and 322
	 */
	define('CMS_MULTI_LANG_PAGE_IGNORE_JSON', '[\"*\",\"!228/*\",\"!228\"]'); 

	define('CMS_MULTI_LANG_GEN_URL_FUNCTION_TO_DEFAULT_TO_P_LANGUAGE', true); // defaults Page::generate_url langauge to the global \$p language
	define('CMS_MULTI_LANG_OTHER_DEFAULT_TO_P_LANGUAGE', true); // defaults CMSNav::_tree langauge to the global \$p language

	define('CMS_MULTI_LANG_SWITCH_MODE', 
	    'URL_SUBDIR'                            // URL_SUBDIR = domain.com/lv/about-us, domain.com/about-us, domain.com/de/about-us
	    //'URL_SUBDOMAIN'                       // URL_SUBDOMAIN = de.domain.com/about-us, www.de.domain.com/about-us, www.domain.com/about-us, shop.de.domain.com/about-us
	    //'URL_TLD'                             // URL_TLD = domain.de/about-us, domain.co.uk/about-us, domain.lv/about-us
	    //'URL_DOMAIN'                          // URL_DOMAIN = english-domain.com/about-us, german-domain.de/about-us, domain-lativan.lv/about-us
	);

	// The following is not advised by google.
	define('CMS_MULTI_URL_PARAM_SWITCH', false); // domain.de/about-us?lang=de, domain.de/about-us?lang=en, domain.de/about-us
	define('CMS_MULTI_URL_PARAM_SWITCH_NAME', 'lang');

	// The following is not advised by google. Overwrites param switch
	define('CMS_MULTI_SESSION_SWITCH', false); 
	define('CMS_MULTI_SESSION_SWITCH_NAME', 'lang');

	define('CMS_MULTI_LANG_CODE_MIN_LENGTH', 2); 
	define('CMS_MULTI_LANG_CODE_MAX_LENGTH', 2); 

	// All these potentially warry on different servers. Run 'locale -a' for a full list of supported locales on your server
	define('CMS_MULTI_LANG_CODE_', 'en_GB.utf8');
	define('CMS_MULTI_LANG_CODE_de', 'de_DE.utf8');
	//define('CMS_MULTI_LANG_CODE_lv', 'lv_LV.UTF-8');
	//define('CMS_MULTI_LANG_CODE_ar', 'ar_SA.UTF-8');
	//define('CMS_MULTI_LANG_CODE_no', 'no_NO.UTF-8');
	//define('CMS_MULTI_LANG_CODE_es', 'es_ES.UTF-8');
	//define('CMS_MULTI_LANG_CODE_fr', 'fr_FR.UTF-8');

	define('CMS_MULTI_LANG_PAGE_TITLE_IN_JSON', true);
	define('CMS_MULTI_LANG_SEO_DETAILS_IN_JSON', false);

	define('CMS_MULTI_LANG_GETTEXT_TRANSLATION', true);", "constant" => "CMS_MULTI_LANG"),
	array("php" => "/**
 * ELOQUENT ORM SWITCH
 *
 * you need to have this
 *
 * \"require\": {
 *    \"illuminate/database\": \"5.0.4\"
 * }
 *
 * in composer.json and run composer update
 *
 */
define(\"ELOQUENT_ORM\", false);", "constant" => "ELOQUENT_ORM"),

);

$settings_amends = "";

foreach ( $constant_check_table as $constant_check ) {

	if ( !defined($constant_check["constant"]) ) {

		$settings_amends .= $constant_check["php"]."
";

	}

}


echo "<pre>";

if ( !empty($settings_amends) ) {
	echo "add the following settings to settings.php\n";
}
echo $settings_amends;

echo "\n\n\n\n";

echo "run the following sql query:\n";

echo "--
-- Table structure for table `languages`
--

CREATE TABLE IF NOT EXISTS `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(63) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `code` varchar(12) NOT NULL,
  `localisation` varchar(12) NOT NULL,
  `text_direction` varchar(10) NOT NULL,
  `image` varchar(512) NOT NULL,
  `custom_code` varchar(63) NOT NULL,
  `default` tinyint(1) NOT NULL COMMENT 'For reference.',
  `country` varchar(63) NOT NULL,
  `time_format` varchar(63) NOT NULL,
  `date_format` varchar(63) NOT NULL,
  `lang_file` varchar(512) NOT NULL,
  `domain` varchar(64) NOT NULL,
  `order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

INSERT INTO `languages` (`id`, `name`, `active`, `code`, `localisation`, `text_direction`, `image`, `custom_code`, `default`, `country`, `time_format`, `date_format`, `lang_file`, `domain`, `order`) VALUES
(1, 'English', 1, 'en', '', 'LTR', '', 'EN', 1, '', '', '', 'en.po', '', 0),
(4, 'French', 0, 'fr', 'fr_FR', 'LTR', '', 'FR', 0, 'France', '', '', 'myWebsite', 'myWebsite', 0),
(5, 'Spanish', 0, 'es', 'es_ES', 'LTR', '', 'ES', 0, 'Spain', '', '', 'myWebsite', 'myWebsite', 0),
(6, 'Norwegian', 0, 'no', 'no_NO', 'LTR', '', 'NO', 0, 'Norway', '', '', 'myWebsite', 'myWebsite', 0),
(7, 'German', 0, 'de', 'de_DE', 'LTR', '', 'DE', 0, '', '', '', '', 'myWebsite', 0),
(8, 'Danish', 0, 'da', 'da_DK', 'LTR', '', 'DA', 0, '', '', '', '', 'myWebsite', 0),
(9, 'Finnish', 0, 'fi', 'fi_FI', 'LTR', '', 'FI', 0, '', '', '', '', 'myWebsite', 0),
(10, 'Italian', 0, 'it', 'it_IT', 'LTR', '', 'IT', 0, '', '', '', '', 'myWebsite', 0),
(11, 'Dutch', 0, 'nl', 'nl_NL', 'LTR', '', 'NL', 0, '', '', '', '', 'myWebsite', 0),
(12, 'Portuguese', 0, 'pt', 'pt_PT', 'LTR', '', 'PT', 0, '', '', '', '', 'myWebsite', 0),
(13, 'Swedish', 0, 'sv', 'sv_SE', 'LTR', '', 'SE', 0, '', '', '', '', 'myWebsite', 0),
(14, 'Arabic', 0, 'ar', 'ar_SA', 'LTR', '', 'SA', 0, '', '', '', 'myWebsite', 'myWebsite', 0);

--
-- Table structure for table `listing_cache`
--

CREATE TABLE IF NOT EXISTS `listing_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setup_hash` varchar(32) NOT NULL,
  `result` longtext NOT NULL,
  `query` text NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` timestamp NOT NULL,
  `last_fetched` timestamp NOT NULL,
  `num_of_fetches` int(11) NOT NULL DEFAULT '0',
  `num_of_total_fetches` int(11) NOT NULL DEFAULT '0',
  `refresh_time_in_seconds` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `setup_hash` (`setup_hash`),
  KEY `timestamp` (`created`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

ALTER TABLE `page_cache` 
ADD COLUMN `language` VARCHAR(5) NOT NULL AFTER `url`,
ADD INDEX `language` (`language` ASC);

ALTER TABLE `page_list_item_data` 
CHANGE COLUMN `data3` `data3` VARCHAR(5) NOT NULL ,
ADD INDEX `data3` (`data3` ASC);

ALTER TABLE `pages` 
CHANGE COLUMN `title` `title` VARCHAR(1023) NOT NULL ,
CHANGE COLUMN `search_title` `search_title` VARCHAR(1024) NOT NULL ,
ADD COLUMN `shorturl` VARCHAR(512) NOT NULL AFTER `data3`,
DROP INDEX `title` ,
ADD INDEX `title` (`title`(333) ASC);

UPDATE `page_list_item_data` SET `css_class`='imageUploadifive' WHERE 1 AND `type` = 'image';
UPDATE `page_list_item_data` SET `css_class`='fileUploadifive' WHERE 1 AND `type` = 'file';
UPDATE `pages` SET `type`='default' WHERE 1 AND `type` = 'frontpage';
DELETE FROM `page_cache`;
DELETE FROM `tree_cache`;

--
-- Triggers
--

DELIMITER $$

--
-- page_list Triggers
--

DROP TRIGGER IF EXISTS `after_page_list_delete_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_delete_clean_page_cache`
AFTER DELETE ON `page_list`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

DROP TRIGGER IF EXISTS `after_page_list_insert_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_insert_clean_page_cache`
AFTER INSERT ON `page_list`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

DROP TRIGGER IF EXISTS `after_page_list_update_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_update_clean_page_cache`
AFTER UPDATE ON `page_list`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

--
-- page_list_item Triggers
--

DROP TRIGGER IF EXISTS `after_page_list_item_delete_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_item_delete_clean_page_cache`
AFTER DELETE ON `page_list_item`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

DROP TRIGGER IF EXISTS `after_page_list_item_insert_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_item_insert_clean_page_cache`
AFTER INSERT ON `page_list_item`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

DROP TRIGGER IF EXISTS `after_page_list_item_update_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_item_update_clean_page_cache`
AFTER UPDATE ON `page_list_item`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

--
-- page_list_item_data Triggers
--

DROP TRIGGER IF EXISTS `after_page_list_item_data_delete_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_item_data_delete_clean_page_cache`
AFTER DELETE ON `page_list_item_data`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

DROP TRIGGER IF EXISTS `after_page_list_item_data_insert_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_item_data_insert_clean_page_cache`
AFTER INSERT ON `page_list_item_data`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

DROP TRIGGER IF EXISTS `after_page_list_item_data_update_clean_page_cache` $$
CREATE
TRIGGER `after_page_list_item_data_update_clean_page_cache`
AFTER UPDATE ON `page_list_item_data`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
END$$

--
-- pages Triggers
--

DROP TRIGGER IF EXISTS `after_pages_delete_clean_page_cache` $$
CREATE
TRIGGER `after_pages_delete_clean_page_cache`
AFTER DELETE ON `pages`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
  DELETE FROM `tree_cache`;
END$$

DROP TRIGGER IF EXISTS `after_pages_insert_clean_page_cache` $$
CREATE
TRIGGER `after_pages_insert_clean_page_cache`
BEFORE INSERT ON `pages`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
  DELETE FROM `tree_cache`;
END$$

DROP TRIGGER IF EXISTS `after_pages_update_clean_page_cache` $$
CREATE
TRIGGER `after_pages_update_clean_page_cache`
AFTER UPDATE ON `pages`
FOR EACH ROW
BEGIN
  DELETE FROM `page_cache`;
  DELETE FROM `tree_cache`;
END$$

DROP TRIGGER IF EXISTS `after_page_cache_delete_clean_temps` $$

DELIMITER ;";