ALTER TABLE `pages`
    ADD COLUMN `directly_viewable` TINYINT(1) NOT NULL DEFAULT '1' AFTER `children_order`,
    ADD COLUMN `history_lock` TINYINT(1) NOT NULL DEFAULT '0' AFTER `directly_viewable`,
    ADD COLUMN `review_status` TINYINT(1) NOT NULL DEFAULT '0' AFTER `history_lock`,
    ADD COLUMN `noindex` TINYINT(1) NOT NULL DEFAULT '0' AFTER `review_status`,
    ADD COLUMN `ajax` TINYINT(1) NOT NULL DEFAULT '0' AFTER `noindex`,
    ADD COLUMN `section` TINYINT(1) NOT NULL DEFAULT '0' AFTER `ajax`,
    ADD COLUMN `versions` TEXT NOT NULL AFTER `section`,
    ADD COLUMN `author_name` VARCHAR(32) NOT NULL AFTER `versions`,
    ADD COLUMN `author_admin_user_id` INT(11) NOT NULL AFTER `author_name`,
    ADD COLUMN `comment` VARCHAR(255) NOT NULL AFTER `author_admin_user_id`,
    ADD INDEX `created` (`created` ASC),
    ADD INDEX `review_status` (`review_status` ASC),
    ADD INDEX `history_lock` (`history_lock` ASC),
    ADD INDEX `section` (`section` ASC),
    ADD INDEX `noindex` (`noindex` ASC),
    ADD INDEX `ajax` (`ajax` ASC),
    ADD INDEX `directly_viewable` (`directly_viewable` ASC),
    ADD INDEX `author_admin_user_id` (`author_admin_user_id` ASC) ;

DELETE FROM pages WHERE type NOT IN ('default', 'button');

UPDATE pages SET data1 = '', data2 = '';

ALTER TABLE `page_list_item_data`
    ADD COLUMN `css_class` VARCHAR(125) NOT NULL AFTER `settings`,
    ADD COLUMN `options` VARCHAR(1024) NOT NULL AFTER `css_class`,
    ADD COLUMN `language` VARCHAR(5) NOT NULL AFTER `options`,
    ADD COLUMN `uuid` BINARY(16) NOT NULL AFTER `language`,
    ADD INDEX `language` (`language` ASC),
    ADD INDEX `uuid` (`uuid` ASC) ;

UPDATE `page_list_item_data` SET `css_class`=`data1`, `options`=`data2`, `language`=`data3`;

ALTER TABLE  `page_list`
    ADD  `allow_more_max` INT NOT NULL DEFAULT  '0',
    ADD  `allow_more_min` INT NOT NULL DEFAULT  '1';

ALTER TABLE `listing_cache`
    CHANGE COLUMN `refresh_time_in_seconds` `refresh_time_in_seconds` DOUBLE NOT NULL ,
    ADD COLUMN `params` TEXT NOT NULL AFTER `query`;
