<?php
/**
 * File handles files uploaded through uploadiFive
 */
$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");
use Mtc\Cms\Models\PageListItemData as PageListItemData;

if (isset($_GET['page_id'])
    && is_numeric($_GET['page_id'])
    && in_array($_GET['type'], ['file', 'image'])
    && !empty($_POST['list_item_data_id'])
    && !empty($_FILES['pagedata']['name'])) {
    $type = $_GET['type'];
    $list_item_data = PageListItemData::find($_POST['list_item_data_id']);
} else {
    die("Invalid request.");
}

/*
 * Check uploaded mime type against allowed types
 */
if (!empty($list_item_data->mime)) {
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mime = finfo_file($finfo, $_FILES['pagedata']['tmp_name']);
    if (!preg_match("/{$list_item_data->mime}/", $mime)) {
        header("HTTP/1.1 415");
        exit($mime);
    }
}

/*
 * Check uploaded image is cymk
 */
$image_info = getimagesize($_FILES['pagedata']['tmp_name']);
if(isset($image_info['channels'])) {
    if ($image_info['channels'] == 4) { // is CMYK
        $alert_message = "The image uploaded ("
                         . $_FILES['pagedata']['name']
                         . ") has paper print colour format (CYMK), there might be some discoloraition as it's converted to web friendly colour (RGB)";
        ContentManagerPanel::addMessage($alert_message, "alert");
    }
}

$files = array();
$files['pagedata']['size'][$_POST['list_item_data_id']]["new_{$type}_value"] = $_FILES['pagedata']['size'];
$files['pagedata']['name'][$_POST['list_item_data_id']]["new_{$type}_value"] = $_FILES['pagedata']['name'];
$files['pagedata']['tmp_name'][$_POST['list_item_data_id']]["new_{$type}_value"] = $_FILES['pagedata']['tmp_name'];

$post = array();
$post['pagedata'][$_POST['list_item_data_id']]['value'] = $_POST['list_item_data_value'];
$post['pagedata'][$_POST['list_item_data_id']]['type'] = $type;

if ($type == 'image') {
    // get $image_folders from settings.php
    global $image_folders;

    $specified_folders = $image_folders['cms_images'];

    // Get page_list_item_data
    $page_list_item_data = PageListItemData::find($_POST['list_item_data_id']);
    // Fetch the settings
    $settings = json_decode($page_list_item_data->settings, true);
    //checking if image_sizes is defined in page_list_item_data settings
    if (!empty($settings) && isset($settings['image_sizes'])) {
        //'small' and 'original' are mandatory sizes. Shift them in array if missing
        if (!in_array('small', $settings['image_sizes'])) {
            $settings['image_sizes'][] = "small";
        }
        if (!in_array('original', $settings['image_sizes'])) {
            $settings['image_sizes'][] = "original";
        }
        //Amend specified folders if not specified in image_sizes
        foreach ($specified_folders as $folder => $data) {
            if (!in_array($folder, $settings['image_sizes'])) {
                unset($specified_folders[$folder]);
            }
        }
    }

    $filename = add_fullcms_image(
        $specified_folders,
        (int) $files['pagedata']['size'][$_POST['list_item_data_id']]['new_image_value'],
        $files['pagedata']['name'][$_POST['list_item_data_id']]['new_image_value'],
        $files['pagedata']['tmp_name'][$_POST['list_item_data_id']]['new_image_value'],
        $list_item_data->mime
    );
} elseif ($type = 'file') {
    $filename = add_fullcms_file(
        (int)$files['pagedata']['size'][$_POST['list_item_data_id']]['new_file_value'],
        $files['pagedata']['name'][$_POST['list_item_data_id']]['new_file_value'],
        $files['pagedata']['tmp_name'][$_POST['list_item_data_id']]['new_file_value'],
        $list_item_data->mime
    );
}

if (!empty($filename)) {
    die($filename);
}
