<?php

use MtcPharmacy\Multisite\Classes\MultisiteManager;
use Mtc\Cms\Models\Page as CmsPage;


$cms_root_path = "../../";
require_once $cms_root_path . "includes/compatibility_includer.php";

$page_meta['title'] = 'Manage Pages';

$requested_page = CmsPage::find($_REQUEST['page'] ?? null);
if (! $requested_page) {
    $requested_page = CmsPage::find(CMS_ROOT_PAGE_ID);

    header('Location: ' . $requested_page->getAdminUrl());
    exit;
}

if ($requested_page->parentPage) {
    $root_page = $requested_page->getAncestors()->last();
} else {
    $root_page = $requested_page;
}

$mm = new MultisiteManager($root_page);
$mm->ensureTheCorrectAdminPageLoaded();


$cm = new ContentManager();
$cmPanel = new ContentManagerPanel();

$adminuser = new adminuser();
$cmPanel->checkPermissions($adminuser->user['id']);
$cmPanel->setUserName($adminuser->user['name']);
$cmPanel->setUserId($adminuser->user['id']);
$cmPanel->mergeSessionMessages();

require_once $core_root_path . "admin/templates/adminheader.html.php";

Event::dispatch('AdminBeforeBreadcrumbs', [
    'concrete_entity' => $root_page ?? null,
    'allow_mode_switching' => false,
]);

?>

<script type="text/javascript">

    <?php
    $cm_panel_dynamic_data = array();
    $cm_panel_dynamic_data["IS_ADMIN"] = "false";
    if ($_SESSION['content_manager']['is_mtcadmin']) {
        $cm_panel_dynamic_data["IS_ADMIN"] = "true";
    }
    $cm_panel_dynamic_data["HISTORY"] = "false";
    if (defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING == true) {
        $cm_panel_dynamic_data["HISTORY"] = "true";
    }
    ?>

    var cmPanelDynamicData = {
        'TITLE_POSTFIX': ' - <?=addslashes(config('app.name'))?> Admin',
        'PAGE_TITLE': '<?= $page_meta['title'] ?>',
        'SITE_URL': '<?=SITE_URL?>',
        'IS_ADMIN': <?=$cm_panel_dynamic_data["IS_ADMIN"]?>, // for usability changes only
        'HISTORY': <?=$cm_panel_dynamic_data["HISTORY"]?>
    };

</script>

<script type="text/javascript" src="js/functions.js"></script>
<script type="text/javascript" src="js/functions_custom.js"></script>
<script type="text/javascript" src="js/init.js"></script>
<script type="text/javascript" src="js/init_custom.js"></script>
<script type="text/javascript" src="js/panel-init.js"></script>
<script type="text/javascript" src="js/panel-init_custom.js"></script>
<script type="text/javascript" src="js/listing-init.js"></script>
<script type="text/javascript" src="js/listing-init_custom.js"></script>
<script type="text/javascript" src="js/history-init.js"></script>
<script type="text/javascript" src="js/history-init_custom.js"></script>
<script type="text/javascript" src="js/dashboard-init.js"></script>
<script type="text/javascript" src="js/dashboard-init_custom.js"></script>
<script type="text/javascript" src="js/pagedata-init.js"></script>
<script type="text/javascript" src="js/pagedata-init_custom.js"></script>
<script type="text/javascript" src="js/pagedata-destroy.js"></script>
<script type="text/javascript" src="js/pagedata-destroy_custom.js"></script>
<script type="text/javascript" src="js/script.js"></script>
<script type="text/javascript" src="js/script_custom.js"></script>



<ul class="breadcrumbs el">
    <li><a title="Home" href="/cms/admin/content_manager">Home</a>&nbsp;/&nbsp;</li>
    <li title="Content Manager" class="end">Content Manager</li>
</ul>


<div class="topBar clearfix">

	<ul class="titleTabs tabnav el">
        <li class="tobBarTab newPageTab">
            <a href="#">Add Page</a>
        </li>

        <li class="tobBarTab updatePageTab">
        	<a href="#tab=1" class="openManagePageTab workAreaH" id="workAreaH">Update Page</a>
        </li>

        <li class="tobBarTab manageListingTab" style="display:none">
            <a href="#tab=2" class="">Manage News</a></li>
        </li>

        <li class="tobBarTab manageParentListingTab" style="display:none">
            <a href="?page=1#tab=2" class=""</a></li>
        </li>

        <?php
        if (defined("CMS_PAGE_VERSIONING") && CMS_PAGE_VERSIONING === true) {
            ?><li class="tobBarTab historyTab" style="display:none">
                <a href="#tab=3" class="">Page Versions</a></li>
            </li><?php
        }
        ?>

    </ul>

    <div class="layoutOptions">
    	<a href="#" title="Layout Padding Toggle"><button class="btn layoutPaddingBtn topBarBtn"><i class="fa fa-list-ul"></i></button></a>
    </div>

    <div class="layoutOptions">
        <button class="btn createNewPageBtn" data-root-page-id="<?= $root_page->id ?>">
            <i class="fa fa-plus-circle btn-fa-icon"></i>NEW PAGE
        </button>
    </div>

    <?php
    if ((!empty($_SESSION['content_manager']['is_client_view'])
            || !empty($_SESSION['content_manager']['is_mtcadmin']))
        && $adminuser->isMtcAdmin()
    ) {
    ?>

    <div class="clientViewSwitch">
        <div class="checkboxToggleWrap">

            <label for="switchView">
                <?php
                if (!empty($_SESSION['content_manager']['is_client_view'])) {
                    echo "Switch to mtc view";
                } else {
                    echo "Switch to client view";
                }
                ?>
            </label>

            <input type="checkbox" id="switchView" class="layoutAdminToggle checkboxToggle <?php
                if (!empty($_SESSION['content_manager']['is_client_view'])) {
                    echo "js_checked";
                } else {
                    echo "";
                }
            ?>">
            <label for="switchView"></label>

        </div>
    </div>
    <?php
    }
    ?>

	<div id="controlPanelLoader" class="controlPanelLoader">
		<span class="spinnerContainer">
		  <span class="spinner"></span>
		</span>
		<span class="loaderMessage">loading...</span>
	</div>
</div>

<div class="cmsPanelMessages">
    <?php
    foreach ($cmPanel->messages as $class => $messages) {
        if (empty($messages)) {
            continue;
        }
        ?>
        <div class="msg <?=clean_page($class)?>">
            <?php
            $already_displayed_messages = array();
            foreach ($messages as $key => $message) {
                if (in_array($message, $already_displayed_messages)) {
                    continue;
                }
                ?>
                <p>
                    <?=clean_page($message)?>
                </p>
                <?php
                $already_displayed_messages[] = $message;
            }
            ?>
        </div>
        <?php
    }
    ?>
</div>

<div id="workArea" class="workArea">
</div><!--end of .workArea-->

<?php
require_once $core_root_path . "admin/templates/adminfooter.html.php";
