<?php

use Mtc\Core\Permissions;

$path = '../../../';
require $path . 'core/includes/header.inc.php';

init_request_values([
    'page' => null,
    'credentials' => null,
]);

//initialize variables
if (!isset($_REQUEST['id'])) {
    $_REQUEST['id'] = null;
}
if (!isset($_REQUEST['action'])) {
    $_REQUEST['action'] = null;
}
$errors = [];

//only mtcadmin can edit mtcadmin
if ($_REQUEST['id'] == MTCADMIN_USERID && $adminuser->user['id'] != MTCADMIN_USERID) {
    header("Location: /admin/index.php?access=none");
    exit();
}

$can_manage_user_roles = AdminUser::can(10, $adminuser->user['id']);
if ($_REQUEST['id'] != $adminuser->user['id'] && !$can_manage_user_roles) {
    header("Location: /admin/index.php?access=none");
    exit();
}

if ($_REQUEST['id'] > 0) {
    $add_or_edit = 'Update';
    $edit_id = $_REQUEST['id'];
} else {
    $add_or_edit = 'Add';
    $edit_id = 0;
}


$pagename = 'Admin User';
$table = 'admin_users';
$page_meta['title'] = $add_or_edit . ' ' . $pagename;

$display_form = true;

// initialise temp user to use for adding/updating/getting details
$tmp_user = new AdminUser();

$user = [
    'name' => '',
    'username' => '',
    'email' => '',
];

$admin_eloquent = null;
$can_manage_category_restrictions = false;

if ($edit_id > 0) {
    $user = $tmp_user->get_user($edit_id);
    /** @var \Mtc\Core\Admin\User $admin_eloquent */
    $admin_eloquent = \Mtc\Core\Admin\User::find($user['id']);
    $can_manage_category_restrictions = Permissions::can(Permissions::RESTRICTED_ORDER_CATEGORIES, $tmp_user->user['id']) && $user['id'] !== $adminuser->user['id'];
}


/*
 * Add
 */
if ($_REQUEST['action'] == 'update') {
    // do add/edit
    // set data
    $user['name'] = !empty($edit_id) ?
        $_REQUEST['name'] :
        $_REQUEST['firstname'] . ' ' . $_REQUEST['lastname'];
    $user['username'] = $_REQUEST['username'];
    $user['email'] = $_REQUEST['email'];
    $user['credentials'] = $_REQUEST['credentials'];

    // if editor can change the role of this user
    if ($can_manage_user_roles) {
        $user['role'] = $_REQUEST['role'];
    }

    if (!empty($_FILES['userfile']['size'])) {
        $file_data = upload_image('userfile', $image_folders['signature']);
        if (!empty($file_data['name']) && empty($file_data['error'])) {
            $user['signature'] = $file_data['name'];
        }
    } elseif (!empty($_POST['delete_image'])) {
        $user['signature'] = '';
    }

    // error reporting
    $usernameExists = \Mtc\Core\AdminUser::query()
        ->where('username', '=', $user['username'])
        ->where('id', '<>', $_REQUEST['id'])
        ->exists();
    if ($usernameExists) {
        $errors[] = "This username is already in use. Please choose another.";
    }

    $emailExists = \Mtc\Core\AdminUser::query()
        ->where('email', '=', $user['email'])
        ->where('id', '<>', $_REQUEST['id'])
        ->exists();
    if ($emailExists) {
        $errors[] = "This email address is already in use.";
    }


    // check if password is suposed to get updated or not
    if (($_REQUEST['id'] == '' && $_REQUEST['password'] == '')) {
        $errors[] = "You must enter a password";
    } elseif ($_REQUEST['password'] != $_REQUEST['password2']) {
        $errors[] = "Your passwords did not match";
    } elseif ($_REQUEST['password'] != '' && strlen($_REQUEST['password']) < 6) {
        $errors[] = "Your password must be at least 6 characters.";
    }
    if ($_REQUEST['password'] != '') {
        $user['password'] = $tmp_user->encrypt_pass($_REQUEST['password'], $user['username']);
    }

    // if no errors do the update / insert
    if (empty($errors)) {
        if ($_REQUEST['id'] != '') {
            // update
            $tmp_user->update($user);
            $success = "The user " . clean_page($user['username']) . " has been updated.";
        } else {
            // insert
            $user['id'] = $tmp_user->create($user);
            $add_or_edit = 'Update';
            $_REQUEST['id'] = $user['id'];
            $success = "The user " . clean_page($user['username']) . " has been added.";
        }

        if ($can_manage_category_restrictions) {
            if (empty($admin_eloquent)) {
                $admin_eloquent = \Mtc\Core\Admin\User::find($user['id']);
            }
            $admin_eloquent->setRestrictedCategories($_POST['restricted_categories'] ?? []);
        }

        if (isset($_REQUEST['policies'])) {
            $admin_eloquent->confirmedPolicies()->sync($_REQUEST['policies']);
        }

        $updated = true;
    }
}

if (! isset($user_permissions)) {
    $user_permissions = [];
}

$policies = \Mtc\Modules\DoctorPolicy\Classes\DoctorPolicy::all();
$user_policies = [];
if ($admin_eloquent) {
    $user_policies = optional($admin_eloquent->confirmedPolicies)->keyBy('id') ?? [];
}

require_once $path . 'core/admin/templates/adminheader.html.php';

?>
    <ul class="breadcrumbs el">
        <li><a href="/admin/">Home</a> /</li>
        <li class="end"><?= $add_or_edit ?> <?= $pagename ?></li>
    </ul>

    <h1><?= $add_or_edit ?> <?= $pagename ?></h1>

<?php

include __DIR__ . '/tabnav.php';

if (!empty($updated) && empty($errors) && isset($_REQUEST['action'])) {
    echo showmsg($pagename . " updated", "success", $path);
}

if (!empty($errors)) {
    showerrors($errors);
}

if ($display_form) {
    ?>
    <form action="<?= \Util::add_query_arg(['id' => $edit_id]) ?>" method="POST" enctype="multipart/form-data"
          class="style">

        <fieldset class="show">
            <h1><a class="show el">Information <i class="fa fa-caret-right"></i></a></h1>

            <?php
            if ($can_manage_user_roles) {
                ?>
                <div class="row">
                    <label for="role">
                        Role
                    </label>
                    <select name="role" id="role">
                        <option value="0">Choose Role</option>
                        <?php
                        foreach (\Mtc\Core\Admin\Role::all() as $role) {
                            ?>
                            <option value="<?= (int)$role->id ?>" <?= ($user['role'] ?? null) == $role->id ? 'selected' : '' ?>>
                                <?= clean_page($role->name) ?>
                            </option>
                            <?php
                        }
                        ?>
                    </select>
                </div>
                <?php
            }

            if (!empty($edit_id)) {
            ?>
                <div class="row">
                    <label for="name">Name</label>
                    <input type="text" name="name" id="name" value="<?php echo $user['name']; ?>" class="INPUT1">
                </div>
            <?php
            } else {
            ?>
                <div class="row">
                    <label for="firstname">First Name</label>
                    <input type="text" name="firstname" id="firstname" value="" class="INPUT1">
                </div>
                <div class="row">
                    <label for="lastname">Last Name</label>
                    <input type="text" name="lastname" id="lastname" value="" class="INPUT1">
                </div>
            <?php
            }
            ?>

            <div class="row">
                <label for="username">Username</label>
                <input type="text" name="username" id="username" value="<?php echo $user['username']; ?>"
                       class="INPUT1" <?= ($add_or_edit == 'Update') ? 'readonly' : '' ?>>
            </div>

            <div class="row">
                <label for="email">Email Address</label>
                <input type="text" name="email" id="email" value="<?php echo $user['email']; ?>" class="INPUT1">
            </div>

            <div class="row">
                <label for="password">Password</label>
                <input type="password" name="password" id="password" value="" class="INPUT1">
            </div>

            <div class="row">
                <label for="password2">Confirm Password</label>
                <input type="password" name="password2" id="password2" value="" class="INPUT1">
            </div>

            <?php
            if (Permissions::can(Permissions::DOCTOR_SIGNATURE)) {
                ?>

                <div class="row">
                    <label for="credentials">Credentials</label>
                    <textarea name="credentials" id="credentials"><?= clean_page($user['credentials']) ?></textarea>
                </div>

                <?php
                if (!empty($user['signature'])) {
                    ?>

                    <div class="row">
                        <label>Signature</label>
                        <img src="/<?= clean_page($image_folders['signature']['thumb']['path']) ?>/<?= clean_page($user['signature']) ?>"
                             alt="Signature"/>
                    </div>

                    <div class="row">
                        <label for="delete_image">
                            Remove Signature
                        </label>
                        <input type="checkbox"
                               id="delete_image"
                               name="delete_image"/>
                    </div>
                    <?php
                }
                ?>
                <div class="row">
                    <label for="image">
                        Upload Signature
                    </label>
                    <input id="image"
                           type="file"
                           name="userfile"/>
                </div>

                <?php
            } else {
                ?>

                <div class="row">
                    <label>Signature</label>
                    <?php

                    if (!empty($user['signature'])) {
                        ?>
                        <img src="/<?= clean_page($image_folders['signature']['thumb']['path']) ?>/<?= clean_page($user['signature']) ?>"
                             alt="Signature"/>

                        <?php
                    } else {
                        echo "Signature not uploaded for user";
                    }
                    ?>
                </div>
                <?php

            }

            // Doctors have limited access to orders by categories
            if ($can_manage_category_restrictions) {
                $selected = [];
                if (!empty($admin_eloquent->allowedCategories)) {
                    $selected = $admin_eloquent->allowedCategories
                        ->pluck('category_id')
                        ->toArray();
                }
                ?>
                <div class="row">
                    <label for="restricted_categories">
                        Allowed Categories
                    </label>
                    <select name="restricted_categories[]" id="restricted_categories" multiple>
                        <?= get_the_categories($selected) ?>
                    </select>
                    <div class="hint el">
                        <i class="fa fa-info-circle"></i>
                        <div class="text">
                            Use Cmd/Ctrl key to select/deselect multiple items
                        </div>
                    </div>
                </div>

                <?php
            }

            if ($policies->isNotEmpty()) {
                $disabled = $admin_eloquent->id != $adminuser->user['id'];
                ?>
                <h4>Policies</h4>
                <p>You must agree to following policies:</p>
                <?php
                foreach ($policies as $policy) {
                    $link = " ( <a href='{$policy->url}' target='_blank'>{$policy->url}</a> )";
                    if (!empty($user_policies[$policy->id])) {
                        $signed_date = $user_policies[$policy->id]->pivot->created_at;
                        $link .= " <em>Signed on {$signed_date}</em>";
                    }
                    echo \Mtc\Core\FormField::renderField([
                        'type' => 'checkbox',
                        'name' => "policies[]",
                        'disabled' => $disabled,
                        'id' => "policy_{$policy->id}",
                        'row_class' => 'checkboxRow',
                        'label' =>  ' ' . $policy->name . $link,
                        'value' => !empty($user_policies[$policy->id]) ? $policy->id : 0,
                        'field_value' => $policy->id
                    ], $twig);
                }
            }
            ?>
        </fieldset>

        <?php
        if ($admin_eloquent && Permissions::can(Permissions::REVIEW_DOCTOR_ORDERS)) { ?>
            <fieldset>
                <h1><a class="show el">Prescription history <i class="fa fa-caret-right"></i></a></h1>

                <table class="manage-items">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Item</th>
                            <th>Approved at</th>
                        </tr>
                    </thead>
                    <?php
                    $pageNum = $_REQUEST['page'] ?: 1;
                    $rowsPerPage = 100;
                    $totalnumrows = ApprovalLog::whereUserId($admin_eloquent->id)->count();
                    $append = '&id=' . $_REQUEST['id'];
                    $items = ApprovalLog::whereUserId($admin_eloquent->id)
                        ->orderBy('id', 'desc')
                        ->take($rowsPerPage)
                        ->offset($rowsPerPage * ($pageNum - 1))
                        ->get();
                    foreach ($items as $item) {
                        $order = Mtc\Shop\Order::query()->whereHas('items', function ($query) use ($item) {
                            $query->where('id', '=', $item->order_item_id);
                        })->first();
                        if ($order && $order->items) {
                            $item_data = $order->items->reject(function ($value, $key) use ($item) {
                                return $value->id !== $item->order_item_id;
                            })->first();

                            $item_object = new Item($item_data->item_id);
                            ?>
                            <tr>
                                <td>
                                    <a href="/shop/admin/orders/manage.order.php?id=<?php echo $order->id; ?>">#<?php echo $order->id; ?></a>
                                </td>
                                <td>
                                    <a href="/shop/admin/products/item.php?id=<?php echo $item_object->id; ?>"><?php echo $item_object->name; ?></a>
                                </td>
                                <td><?php echo $item->created_at; ?></td>
                            </tr>
                            <?php

                        }
                    }
                    ?>
                </table>
                <?php

                require $path . 'core/admin/templates/pagination.php';
                ?>
            </fieldset>
        <?php } ?>

        <input type="hidden" name="action" value="update"/>
        <input type="hidden" name="id" value="<?php echo $_REQUEST['id']; ?>"/>

        <div class="row"><input type="submit" value="Save"/></div>

    </form>

    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
