<?php

$path = '../../../';
require $path . 'core/includes/header.inc.php';

// initialize variables
if (!isset($_REQUEST['action'])) {
    $_REQUEST['action'] = null;
}
$errors = [];

$pagename = 'Admin User';
$table = 'admin_users';
$page_meta['title'] = 'Manage ' . $pagename . 's';

/*
    Delete
*/
if ($_REQUEST['action'] == 'delete' && is_numeric($_REQUEST['delete_id'])) {
    \Mtc\Core\AdminUser::query()
        ->where('id', $_REQUEST['delete_id'])
        ->delete();
}

if ($_REQUEST['action'] == 'loginas' && isset($_REQUEST['userid']) && is_numeric($_REQUEST['userid'])) {
    $_SESSION['adminId'] = $_REQUEST['userid'];
    \Mtc\Core\AdminUser::query()
        ->where('id', $_REQUEST['userid'])
        ->update([
                'session_id' => session_id()
        ]);
    header("Location: /admin/index.php");
    exit();
}

$roles = \Mtc\Core\Admin\Role::all();

include $path . 'core/admin/templates/adminheader.html.php';

?>

<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Manage <?=$pagename?>s</li>
</ul>

<h1>Manage <?=$pagename?>s</h1>

<?php

include 'tabnav.php';

if (sizeof($errors) > 0) {
    showerrors($errors);
}

$adminUsers = \Mtc\Core\AdminUser::query()
    ->orderBy('id', 'DESC')
    ->when(!$adminuser->isMtcAdmin(), function ($query) {
        $query->where('id', '!=', MTCADMIN_USERID);
    })
    ->get();

if ($adminUsers->count() > 0) {

    if (sizeof($errors) == 0 && isset($_REQUEST['action'])) {
        echo showmsg("Record updated", "success", $path);
    }

    ?>
    <form action="<?= $_SERVER['PHP_SELF'];?>" method="post">
        <table class="manage-items">
            <tr>
                <th>Name</th>
                <th>Role</th>
                <th>Last Login</th>
                <th>Login as this User</th>
                <th class="center">Edit</th>
                <th class="center">Delete</th>
            </tr>
            <tbody class="tabular">
            <?php
            $flag = false;
            foreach ($adminUsers as $adminUser) {
                $data = $adminUser->toArray();
                $flag = !$flag;
                ?>
                <tr id="rorder-<?=$data['id']?>">
                    <td><a href="edit.php?id=<?=  $data['id'];?>"><?php echo $data['name'];?></a></td>
                    <td>
                        <?= clean_page($roles->where('id', $data['role'])->first()->name ?? '') ?>
                    </td>
                    <td><?php if ($data['last_login'] != '0000-00-00 00:00:00') {echo date('d/m/Y H:i:s',strtotime($data['last_login']));} else {echo 'Never';} ?></td>
                    <td><a href="manage.php?action=loginas&userid=<?php echo $data['id'];?>" class="alert" title="This will log you out of your current session and log you back in as this user. Do you want to proceed?">login <i class="fa fa-share" /></a></td>
                    <td class="center"><a href="edit.php?id=<?=  $data['id'];?>" class="edit picto"><i class="fa fa-pencil"></i></a></td>
                    <td class="center"><a href="manage.php?action=delete&delete_id=<?php echo $data['id'];?>" class="alert error" title="Are you sure you want to delete this?"><i class="fa fa-times-circle"></i></a></td>
                </tr>
                <?php
            }
            ?>
            </tbody>
        </table>
    </form>
    <?php
} else {
    ?>
    <p>No <?=$pagename?>s have been created</p>
    <?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
