<?php

if (empty($noauth) && php_sapi_name() != 'cli') {
    require SITE_PATH . '/core/admin/includes/auth.php';
}

/**
 * Get admin folders from plugins and modules
 */
$admin_folders = [];

$module_types = [
    'plugins',
    'modules',
];

/*
 * Add shop and CMS by default to admin folders array
 */
if (is_dir(SITE_PATH . '/shop/admin/')) {
    $admin_folders[] = SITE_PATH . '/shop/admin/';
}

if (is_dir(SITE_PATH . '/cms/admin/')) {
    $admin_folders[] = SITE_PATH . '/cms/admin/';
}

if (is_dir(SITE_PATH . '/abs/admin/')) {
    $admin_folders[] = SITE_PATH . '/abs/admin/';
}

foreach ($module_types as $module_type) {

    if (is_dir(SITE_PATH . '/' . $module_type . '/')) {
        if ($handle = opendir(SITE_PATH . '/' . $module_type . '/')) {
            while (false !== ($module = readdir($handle))) {

                if (is_dir(SITE_PATH .'/' . $module_type . '/' . $module)
                    && $module != '.' && $module!='..'
                ) {
                    $module_admin_folder = SITE_PATH . '/' . $module_type . '/' . $module . '/admin/';

                    if (is_dir($module_admin_folder)) {
                        $admin_folders[] = $module_admin_folder;
                    }

                }
            }
            closedir($handle);
        }
    }
}

/**
 * Get admin css/less and js files
 */
$admin_css_files_before = [];
$admin_css_files_after = [];
$admin_js_files = [];
$css_excluded_files = [
    '/core/admin/css/mtc_admin_style.less',
    '/core/admin/css/dynamic_before.less',
    '/core/admin/css/dynamic_after.less',
    '/shop/admin/css/print_order.css',
    '/core/css/style_404.less',
    '/core/css/datepicker.less',
    '/core/css/form.less',
    '/core/css/zoom.less',
    '/core/css/import.less',
];
$js_excluded_files = [
    '/core/js/less.js',
    '/core/js/vue.js',
    '/core/js/vue.min.js',
    '/core/js/pattern_browser.js',
    '/core/js/css_browser.js',
    '/core/js/jquery.js',
    '/core/js/jquery.datetimepicker.js',
    '/core/js/plugins/mtc_zoom.js',
    '/core/js/plugins/mtc_jquery_ui.js',
    '/core/js/site_scripts/mtc_show_hide_menus.js',
];

/**
 * Get default css/less and js
 */
$less_folders = [
    SITE_PATH . '/core/css/*.less',
    SITE_PATH . '/core/admin/css/plugins/*.css',
    SITE_PATH . '/core/admin/css/*.css',
    SITE_PATH . '/core/admin/css/*.less',
];
$js_folders = [
    SITE_PATH . '/core/js/tinymce/*.js',
    SITE_PATH . '/core/js/*.js',
    SITE_PATH . '/core/js/plugins/*.js',
    SITE_PATH . '/core/admin/js/plugins/*.js',
    SITE_PATH . '/core/admin/js/*.js',
];

// css/less
foreach ($less_folders as $directory) {
    foreach (glob($directory) as $file_name) {
        $css_file = str_replace(SITE_PATH, '', $file_name);

        if (!in_array($css_file, $css_excluded_files)) {
            $admin_css_files_before[] = $css_file;
        }
    }
}

// js
foreach ($js_folders as $directory) {
    foreach (glob($directory) as $file_name) {
        $js_file = str_replace(SITE_PATH, '', $file_name);

        if (!in_array($js_file, $js_excluded_files)) {
            $admin_js_files[] = $js_file;
        }
    }
}

/**
 * Get admin extended file paths
 */
foreach ($admin_folders as $directory) {

    if (is_dir($directory . 'css/')) {
        // css
        foreach (glob($directory . 'css/*.css') as $file_name) {

            $css_file = str_replace(SITE_PATH, '', $file_name);

            if (!in_array($css_file, $css_excluded_files)) {
                $admin_css_files_after[] = $css_file;
            }

        }
        // less
        foreach (glob($directory . 'css/*.less') as $file_name) {

            $css_file = str_replace(SITE_PATH, '', $file_name);

            if (!in_array($css_file, $css_excluded_files)) {
                $admin_css_files_after[] = $css_file;
            }

        }
    }

    if (is_dir($directory . 'js/')) {
        foreach (glob($directory . 'js/*.js') as $file_name) {
            $admin_js_files[] = str_replace(SITE_PATH, '', $file_name);
        }
    }
}

$twig->addGlobal('admin_js_files', $admin_js_files);

/**
 * generate dynamic files
 */

//generate /core/admin/css/dynamic_before.less
$dynamic_less = SITE_PATH . '/core/admin/css/dynamic_before.less';
$less_data = '';
foreach ($admin_css_files_before as $file) {
    $less_data .= "@import '" . '../../..' . $file . "';" . PHP_EOL;
}

// write dynamic_before.less if it has changed
if (!file_exists($dynamic_less) || strlen($less_data) !== filesize($dynamic_less)) {
    file_put_contents($dynamic_less, $less_data, LOCK_EX);
}
unset($less_data);

//generate /core/admin/css/dynamic_after.less
$dynamic_less = SITE_PATH . '/core/admin/css/dynamic_after.less';
$less_data = '';
foreach ($admin_css_files_after as $file) {
    $less_data .= "@import '" . '../../..' . $file . "';" . PHP_EOL;
}

// write dynamic_after.less if it has changed
if (!file_exists($dynamic_less) || strlen($less_data) !== filesize($dynamic_less)) {
    file_put_contents($dynamic_less, $less_data, LOCK_EX);
}
unset($less_data);

//generate /core/admin/js/dynamic.json
$dynamic_json = SITE_PATH . '/core/admin/js/dynamic.json';
$json_data = "[\n";
$i = 1;
foreach ($admin_js_files as $file) {
    $json_data .= "    \"../.." . $file;
    $json_data .= ($i < count($admin_js_files)) ? "\",\n" : "\"\n";
    $i++;
}
$json_data .= "]";

// write dynamic_after.less if it has changed
if (!file_exists($dynamic_json) || strlen($json_data) !== filesize($dynamic_json)) {
    file_put_contents($dynamic_json, $json_data, LOCK_EX);
}
unset($json_data);

if (isset($adminuser)) {
    $new_message_count = \Mtc\Plugins\MembersMessaging\Classes\Message::getUnread($adminuser->user['id']);
    $twig->addGlobal('new_message_count', $new_message_count);
}
