<?php

/**
 * Cleaner
 *
 * @package mtc ecommerce
 * @author mtc.
 * @copyright 2013 mtc. http://www.mtcmedia.co.uk/
 * @version 2013
 * @access public
 */
class Cleaner
{

    //you need to extend this big time.
    public $stopwords = array(" find ", " about ", " me ", " ever ", " each ", " update ", " delete ", " add ", " insert ", " where ", " i ", " a ", " my ");
    public $symbols = array('/', '\\', '\'', '"', ',', '.', '<', '>', '?', ';', ':', '[', ']', '{', '}', '|', '=', '+', '-', '_', ')', '(', '*', '&', '^', '%', '$', '#', '@', '!', '~', '`');

    /**
     * Cleaner::parseString()
     *
     * @return
     */
    public function parseString($string)
    {
        $string = ' ' . $string . ' ';
        $string = $this->removeStopwords($string);
        $string = $this->removeSymbols($string);

        return $string;
    }

    /**
     * Cleaner::removeStopwords()
     *
     * @return
     */
    public function removeStopwords($string)
    {
        for ($i = 0; $i < sizeof($this->stopwords); $i++) {
            $string = str_replace($this->stopwords[$i], ' ', $string);
        }

        return trim($string);
    }

    /**
     * Cleaner::removeSymbols()
     *
     * @return
     */
    public function removeSymbols($string)
    {
        for ($i = 0; $i < sizeof($this->symbols); $i++) {
            $string = str_replace($this->symbols[$i], ' ', $string);
        }

        return trim($string);
    }

}
