<?php

use Mtc\Shop\Brand;

/**
 * Seo brands class
 *
 * @author: Lukas Giegerich | mtc.
 * @version 2014-01-20
 */
class SeoBrands extends Seo
{

    function __construct()
    {
        parent::__construct();
    }

    /**
     * gets array of seo data for all brands from db
     *
     * @param int $id
     * @return array
     */
    public function getBrand($id)
    {
        return Brand::query()
            ->where('id', $id)
            ->firstOrNew()
            ->toArray();
    }

    /**
     * updates brand seo data in db
     *
     * @param int $id
     * @param string $title
     * @param string $description
     */
    public function updateBrand($id, $title, $description): void
    {
        Brand::query()
            ->where('id', $id)
            ->update([
                'seo_title' => $title,
                'seo_description' => $description,
            ]);
    }

    /**
     * sets seo data for given brand to empty string
     * @param int $id
     */
    public function deleteBrand($id)
    {
        $this->updateBrand($id, '', '');
    }

}
