<?php

use Mtc\Shop\Category;

/**
 * Seo categories class
 *
 * @author: Lukas Giegerich | mtc.
 * @version 2014-01-20
 */
class SeoCategories extends Seo
{

    function __construct()
    {
        parent::__construct();
    }

    /**
     * gets array of seo data for all categories from db
     *
     * @param int $id
     * @return array
     */
    public function getCategory($id)
    {
        return Category::query()
            ->where('id', $id)
            ->firstOrNew()
            ->toArray();
    }

    /**
     * Gets categories from the database
     *
     * @author Vladislavs Ignatjevs <vladislavs.ignatjevs@mtcmedia.co.uk>
     *
     * @return array
     */
    public function getSeoCategories()
    {
        $categories = Category::query()
            ->where('deleted', 0)
            ->where('sub_id', 0)
            ->orderBy('name')
            ->get()
            ->toArray();

        foreach ($categories as $key => $data) {
            $categories[$key]['sub_categories'] = $this->getSubCategories($data['id']);
        }
        return $categories;
    }

    /**
     * updates category seo data in db
     *
     * @param int $id
     * @param string $title
     * @param string $description
     */
    public function updateCategory($id, $title, $description)
    {
        Category::query()
            ->where('id', $id)
            ->update([
                'seo_title' => $title,
                'seo_description' => $description,
            ]);
    }

    /**
     * sets seo data for given category to empty string
     * @param int $id
     */
    public function deleteCategory($id)
    {
        $this->updateCategory($id, '', '');
    }

    /**
     * Gets sub categories from the database
     *
     * @param int $parent_id
     * @param string $indent
     * @return array
     *
     */
    public function getSubCategories($parent_id, string $indent = ''): array
    {
        $subCategories = Category::query()
            ->where('deleted', 0)
            ->where('sub_id', $parent_id)
            ->orderBy('name')
            ->get()
            ->toArray();

        foreach ($subCategories as $key => $data) {
            $new_indent = $indent . '- ';
            $data['name'] = $new_indent . $data['name'];
            $data['sub_categories'] = $this->getSubCategories($data['id'], $new_indent);
            $subCategories[$key] = $data;
        }

        return $subCategories;
    }

    /**
     * sets seo data for given category to empty string
     *
     * @param array $categories
     * @return string
     *
     * @author Vladislavs Ignatjevs <vladislavs.ignatjevs@mtcmedia.co.uk>
     */
    function seoCategoryHelperPrintCategories($categories)
    {
        $html = '';
        ob_start();
        foreach ($categories as $category) {
            ?>

            <tr>
                <td>
                    <a href="<?= clean_page(browse_url($category['id'])) ?>" target="_blank">
                        <i class="fa fa-eye"></i>
                    </a>
                </td>
                <td><?= clean_page($category['name']) ?></td>
                <td><?= clean_page($category['seo_title']) ?></td>
                <td><?= clean_page($category['seo_description']) ?></td>
                <td>
                    <a href="?edit=<?= clean_page($category['id']) ?>">
                        <i class="fa fa-pencil"></i>
                    </a>
                    <a href="?delete=<?= clean_page($category['id']) ?>" class="alert error"
                       title="Are you sure you want to delete this seo entry?">
                        <i class="fa fa-times-circle"></i>
                    </a>
                </td>
            </tr>


            <?php
            if (count($category['sub_categories']) > 0) {
                echo $this->seoCategoryHelperPrintCategories($category['sub_categories']);
            }
        }
        $html = ob_get_clean();
        return $html;
    }
}
