<?php

use Mtc\Core\Models\SeoDefault;

/**
 * Seo defaults class
 *
 * @author: Lukas Giegerich | mtc.
 * @version 2014-01-20
 */
class SeoDefaults extends Seo
{

    function __construct()
    {
        parent::__construct();
    }

    /**
     * gets array of default seo data from db
     *
     * @param int $id
     * @return array
     */
    public function getDefault($id): array
    {
        return SeoDefault::query()
            ->where('id', $id)
            ->firstOrNew()
            ->toArray();
    }

    /**
     * updates brand seo data in db
     *
     * @param int $id
     * @param string $title
     * @param string $description
     */
    public function updateDefault($id, $title, $description)
    {
        SeoDefault::query()
            ->where('id', $id)
            ->update([
                'title' => $title,
                'description' => $description,
            ]);
    }

}
