<?php

use Mtc\Core\Models\SeoHeading;

/**
 * Seo Headings class
 *
 * @author Ilya Berdnikov | mtc.
 * @version 2015-05-22
 */
class SeoHeadings extends Seo {
    /**
     * list of seo headings
     * @var array
     */
    public $seo_headings = array();
    function __construct() {
        parent::__construct();
    }
    /**
     * gets all seo headings from db
     */
    public function getHeadings(): array
    {
        return SeoHeading::query()
            ->orderBy('path')
            ->get()
            ->keyBy('path')
            ->toArray();
    }
    /**
     * creates or updates seo text entry in db
     *
     * @param string $path
     * @param string $text
     */
    public function createOrUpdate($path, $text)
    {
        SeoHeading::query()
            ->updateOrCreate([
                'path' => $path
            ], [
                'text' => $text,
            ]);
    }
    /**
     * gets seo heading from db based on id
     *
     * @param int $id
     * @return array
     */
    public function getHeading($id): array
    {
        return SeoHeading::query()
            ->where('id', $id)
            ->firstOrNew()
            ->toArray();
    }
    /**
     * deletes seo heading from db
     *
     * @param int $id
     */
    public function deleteHeading($id)
    {
        SeoHeading::query()
            ->where('id', $id)
            ->delete();
    }
}
