$(document).ready(function () {
    //simple map
    if ($('.js_map').length > 0) {
        $('.js_map').mtcGoogleMaps();
    }

    //custom map example
    if ($('.js_customMap').length > 0) {
        $('.js_customMap').mtcGoogleMaps({
            map_options: {
                disableDefaultUI: true,
                zoomControl: true
            },
            infoBox: {
                infoBoxClass: 'infobox infoboxDark'
            },
            styles: [{"featureType":"administrative","elementType":"labels.text.fill","stylers":[{"color":"#444444"}]},{"featureType":"landscape","elementType":"all","stylers":[{"color":"#f2f2f2"}]},{"featureType":"poi","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"road","elementType":"all","stylers":[{"saturation":-100},{"lightness":45}]},{"featureType":"road.highway","elementType":"all","stylers":[{"visibility":"simplified"}]},{"featureType":"road.arterial","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"all","stylers":[{"visibility":"off"}]},{"featureType":"water","elementType":"all","stylers":[{"color":"#2569e3"},{"visibility":"on"}]}]
        });
    }

    //multiple maps example with styled map
    if ($('.js_mapMultiple').length > 0) {
        $('.js_mapMultiple').mtcGoogleMaps();
    }

    //search example
    if ($('.js_mapSearch').length > 0) {
        $('.js_mapSearch').mtcGoogleMaps({
            search: {
                search_results: '#stockistResults',
                search_form: '.stockistSearch',
            },
            marker: {
                icon: '/plugins/GoogleMaps/images/map_marker.png'
            },
            info_box: {
                close_button_markup: '<button>×</button>',
                width: 400,
                offset_x: -100,
                offset_y: -50,
                align_bottom: true,
                close_on_click: true,
                disable_auto_pan: false,
                info_box_class: 'infobox'
            },
        });
    }

    //change map place
    if ($('.js_changeMapPlace').length > 0) {
        $('.js_changeMapPlace').on('click', function (e) {
            var map = $('.js_targetMap'),
                map_plugin = map.data('plugin_mtcGoogleMaps'),
                new_place = {
                    'title' : 'Dundee  office',
                    'coords' : [ 56.4623546, -2.9601447999999664],
                    'description' : '<p>Some Dundee office text here</p>'
                }

            e.preventDefault();

            //plugin places array, clear value
            map_plugin.places.pop();

            //add new value
            map_plugin.places.push(new_place);

            //laod maps settings into google map
            map_plugin.initMap(map.get(0));
        });
    }

    //change google map
    if ($('.js_changeMapOptions').length > 0) {
        $('.js_changeMapOptions').on('click', function (e) {
            var google_map = $('.js_targetMap').data('plugin_mtcGoogleMaps').google_map;

            e.preventDefault();

            //manipulate the map zoom directly
            google_map.setZoom(5);
        });
    }

    //change google map
    if ($('.js_directionsMap').length > 0) {
        $('.js_directionsMap').mtcGoogleMaps({
            directions: true,
            directions_options: {
                onDirectionsLoad: function () {

                    $('html, body').animate({
                        scrollTop: $('.js_directionsMap').offset().top
                    }, 'slow');

                }
            }
        });
    }

});
