#!/bin/sh
# things that need to be done on deployment

#manually clear config cache as sometimes it sticks
rm -f bootstrap/cache/config.php
rm -f bootstrap/cache/packages.php
rm -f bootstrap/cache/services.php

# npm install --no-audit

# Check that Composer is present and generate autoload file
if [ -f ~/public_html/composer.json ]; then
    composer install --no-interaction --no-dev --prefer-dist --optimize-autoloader
else
    echo "Composer files could not be found, you will not get autoloading and dependency management"
fi

# Site migrations
php artisan migrate --force

# publish media manager assets
php artisan vendor:publish --tag=media-manager

echo 'Installing Cron'
sh crons.sh | crontab -
