<?php

use Illuminate\Support\Facades\App;
use Twig\Extra\Intl\IntlExtension;
use Twig\Extra\String\StringExtension;

$template_paths = [];

//if ($_SERVER['PHP_SELF'] == '/core/css/index.php') {
//    $template_paths[] = SITE_PATH . '/core/css/';
//
//    // update first line of less files with layout folder
//    $layout_less = new LayoutBrowser();
//    $layout_less = $layout_less->updateImportPath(SITE_PATH . '/core/css/import.less');
//}

$template_paths[] = SITE_PATH . '/sites/' . SITE . '/templates/';
$template_paths[] = SITE_PATH . '/sites/default/templates/';

/**
 * Include plugins
 *
 * Gets installed plugins and modules (loader.php present) and sets them up
 * for loading after twig loader has been called
 *
 * @return Array
 */


$module_types = array(
    'plugins',
    'modules',
);

$previous_dir = getcwd();
foreach ($module_types as $module_type) {

    $module_folder_parent = SITE_PATH . '/' . $module_type . '/';

    if (is_dir($module_folder_parent)) {
        // descend into the modules/plugins folder
        chdir($module_folder_parent);

        // list of found modules
        $modules = [];

        // check if there is a user-defined module order
        if (file_exists('./.order')) {
            $modules = file('./.order');
            $modules = array_map('trim', $modules);
            $modules = array_filter($modules, function ($module) {
                return !empty($module);
            });
        }

        // add unlisted modules from the modules directory
        $modules = array_merge($modules, glob('*', GLOB_ONLYDIR));
        // remove duplicates
        $modules = array_unique($modules);

        // iterate through modules in the defined order
        foreach ($modules as $module) {
            $module_folder = $module_folder_parent . $module;

            if (is_dir($module_folder) && $module != '.' && $module != '..') {
                if (is_file($module_folder . '/loader.php')) {
                    $loaded_module_paths[] = $module_folder . '/loader.php';
                }

                if (is_file($module_folder . '/hooks.php')) {
                    $loaded_module_hooks[] = $module_folder . '/hooks.php';
                }

                $module_template_folder = $module_folder . '/templates/';

                if (is_dir($module_template_folder)) {
                    $add_template_path = $module_template_folder;
                    $template_paths[] = $add_template_path;
                }

            }
        }
    }
}

// return to the original directory
chdir($previous_dir);

/*
 * Add shop and CMS by default to twig array
 *
 * This stops dependant plugins from throwing errors
 * when using mixins.
 */
if (is_dir(SITE_PATH . '/shop/templates/')) {
    $template_paths[] = SITE_PATH . '/shop/templates/';
}

if (is_dir(SITE_PATH . '/cms/templates/')) {
    $template_paths[] = SITE_PATH . '/cms/templates/';
}

if (is_dir(SITE_PATH . '/abs/templates/')) {
    $template_paths[] = SITE_PATH . '/abs/templates/';
}

$template_paths[] = SITE_PATH . '/core/templates/';


$view_paths = Config::get('view.paths');
foreach ($view_paths as $view_path) {
    $template_paths[] = $view_path;
}


$twig_loader = new \Twig\Loader\FilesystemLoader(
    $template_paths
);

if (config('app.env') !== 'production' && empty($_REQUEST['twig_cache'])) {

    $twig = new \Twig\Environment(
        $twig_loader,
        array(
            'cache' => false,
            'debug' => true
        )
    );

} else {

    $twig = new \Twig\Environment(
        $twig_loader,
        array(
            'cache' => SITE_PATH . '/cache/twig_cache',
            'auto_reload' => true,
            'debug' => false
        )
    );

}

$twig->addExtension(new IntlExtension());

App::instance('twig', $twig);
