<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SeoDefaultsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        echo 'Seeding seo_defaults...' . PHP_EOL;

        DB::table('seo_defaults')->delete();

        DB::table('seo_defaults')->insert(array (
            0 => 
            array (
                'id' => '5',
                'name' => 'browse',
                'path' => '/browse/index.php',
                'title' => '{PAGE} - {CATEGORIES} {BRAND} | {SITE_NAME}',
                'description' => '{PAGE_CONTENT}{155}',
            ),
            1 => 
            array (
                'id' => '6',
                'name' => 'item',
                'path' => '/shop/item.php',
                'title' => '{ITEM} - {BRAND} - {CATEGORY} | {SITE_NAME}',
                'description' => '{ITEM} available online from Cura Pharmacy.',
            ),
            2 => 
            array (
                'id' => '7',
                'name' => 'CMS page',
                'path' => 'cms_page',
                'title' => '{PAGE_TITLE} | {SITE_NAME}',
                'description' => '{PAGE_TITLE} | {SITE_NAME}  is one of the largest independent community pharmacy groups in the UK. Online pharmacy and travel health advice available.',
            ),
            3 => 
            array (
                'id' => '8',
                'name' => 'CMS listing container',
                'path' => 'cms_listing_container',
                'title' => '{PAGE_TITLE} | {SITE_NAME}',
                'description' => '{PAGE_TITLE} | {SITE_NAME}',
            ),
            4 => 
            array (
                'id' => '9',
                'name' => 'CMS listing item',
                'path' => 'cms_listing_item',
                'title' => '{PAGE_TITLE} | {SITE_NAME}',
                'description' => '{PAGE_CONTENT}{155}',
            ),
        ));
        
        
    }
}