<?php
$path = '../../../';
require_once $path.'core/includes/header.inc.php';
require_once 'includes/settings.php'; // MODEL SETTINGS

use Mtc\Modules\DoctorPolicy\Classes\ModuleHelper;
use Mtc\Modules\DoctorPolicy\Classes\ModuleActions;

$model_class_name = MODEL_CLASS_NAMESPACE_PREFIX.MODEL_CLASS_NAME;
$new_object = true;
$page_meta['title'] = 'Add '.ucwords(MODEL_SINGULAR);
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $module['object'] = $model_class_name::find($_GET['id']);

    if ($module['object'] !== null) {
        $page_meta['title'] = 'Edit '.ucwords(MODEL_SINGULAR);
        $new_object = false;
    } else {
        $module['object'] = new $model_class_name();
        unset($_GET['id']);
    }
} else {
    $module['object'] = new $model_class_name();
    unset($_GET['id']);
}

require 'includes/edit__after-model_object-init.php';

$form_messages = array(
    'success' => array(),
    'error' => array(),
    'alert' => array(),
);

/*************************************************************************************************************************************
 *                                                      POSTBACK
*************************************************************************************************************************************/

if (defined('MODEL_TABLE_CREATION_MODE') && MODEL_TABLE_CREATION_MODE === true) {
    $_SESSION['model_form']['alert'][] = 'MODEL_TABLE_CREATION_MODE is set to true! Changes you make to $model_form shall make the database table change with it.';

    $database_table_builder = new \Mtc\Modules\ModuleBuilder\Classes\Builders\DatabaseTableBuilder();
    $database_table_builder->setTableName(MODEL_TABLE_NAME);
    $database_table_builder->setModel($module['object']);
    $result = $database_table_builder->change($model_form);
    $_SESSION['model_form']['alert'] = array_merge($_SESSION['model_form']['alert'], $result);
}

$errors = ModuleActions::resolveEdit(
    $_POST,
    $_GET,
    $_FILES,
    $module['object'],
    $model_form,
    $image_folders,
    MODEL_SINGULAR
);

$form_messages['error'] = array_merge($form_messages['error'], $errors);

require 'includes/edit__before-output.php';

/*************************************************************************************************************************************
 *                                                      OUTPUT
*************************************************************************************************************************************/

require $path.'core/admin/templates/adminheader.html.php';

?>

<!-- MODULE CSS FILES -->
<link rel="stylesheet" href="css/style.css" />
<!-- end of MODULE CSS FILES -->


<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <!-- ANY PARENT PAGES -->
    <li><a href="manage.php"><?='Manage '.clean_page(ucwords(MODEL_PLURAL));?></a> /</li>
    <li class="end"><?=clean_page($page_meta['title'])?></li>
</ul>

<h1><?=clean_page($page_meta['title'])?></h1>

<?php

include("templates/tabs.php");

// process session stored messages, alerts, errros
$form_messages = ModuleHelper::mergeSessionMessages($form_messages);

// Alerts, Errors, Success Messages
ModuleHelper::printMessages($form_messages);

$form = new \Mtc\Modules\ModuleBuilder\Classes\Builders\FormBuilder($twig);

$action = "edit.php";
if (!$new_object) {
    $action .= "?id=".$module['object']->id;
}


$end_form_button_models = array(
    'action' => array(
        'scoped_name' => false,
        'value' => 'update',
        'type' => 'hidden',
        'fieldset' => 'buttons'
    ),
    'id' => array(
        'value' => $module['object']->id,
        'type' => 'hidden',
    ),
    'submit' => array(
        'value' => 'Save',
        'type' => 'submit',
        'label' => "",
        'fieldset' => 'buttons'
    ),
    'buttons' => [
        'type' => 'fieldset',
        'hide_label' => true
    ]
);

$model_form = array_merge($model_form, $end_form_button_models);


echo $form->start(
    $module['object'],
    array(
        'action' => $action,
        'class' => 'style moduleBuilder',
    )
);

echo $form->buildForm($model_form);

echo $form->end();

require $path.'core/admin/templates/adminfooter.html.php';
