<?php
/**
 * This code is used to edit question.
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Modules\FormBuilder\Classes;

use Illuminate\Support\Facades\Schema;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';
$page_meta['title'] = 'Manage Site Forms';

if (isset($_REQUEST['id']) && $_REQUEST['id'] > 0) {
    $add_edit = 'Edit';
    $form_id = (int)$_REQUEST['id'];
} else {
    $add_edit = 'Add';
    $form_id = 0;
}

$last_question_id = FormQuestion::orderBy('id', 'DESC')
    ->pluck('id')
    ->first();
$last_fieldset_id = FormFieldset::orderBy('id', 'DESC')
    ->pluck('id')
    ->first();
$last_option_id = FormQuestionOption::orderBy('id', 'DESC')
    ->pluck('id')
    ->first();
$last_notification_id = FormQuestionEmail::orderBy('id', 'DESC')
    ->pluck('id')
    ->first();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/modules/FormBuilder/admin">Manage Forms</a> /</li>
    <li class="end"><?= clean_page($add_edit) ?> Form</li>
</ul>

<h1>
    <?= clean_page($add_edit) ?> Form
</h1>

<?php
require 'tabnav.php';
?>

<div id="formBuilder">
    <form_builder form_id="<?= $form_id ?>"
                  last_question_id="<?= $last_question_id ?>"
                  last_option_id="<?= $last_option_id ?>"
                  last_notification_id="<?= $last_notification_id; ?>"
                  last_fieldset_id="<?= $last_fieldset_id ?>"
                  inline-template>
        <?php
        require 'templates/form.php';
        ?>
    </form_builder>
</div>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
