<?php
/**
 * Question edit template
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
$allowed_types = ['checkbox', 'radio', 'input', 'select', 'textarea'];
?>
<div class="question clearfix">
    <div class="row show">
        <label for="question_name">
            Name
        </label>
        <input type="text"
               id="question_name"
               v-model="current_question.name">
    </div>

    <div class="row show">
        <label for="question_slug">
            Array Key (for callback)
        </label>
        <input type="text"
               v-bind="name"
               id="question_slug"
               v-model="current_question.slug">
    </div>

    <div class="row show">
        <label for="question_css_class">
            CSS Class
        </label>
        <input type="text"
               id="question_css_class"
               v-model="current_question.css_class">
    </div>
    <div class="row">
        <label for="question_type">
            Type [% current_question.type %]
        </label>
        <select id="question_type"
                v-model="current_question.type"
                class="question_type">

            <option value="">Choose Type</option>

            <option value="input">
                Text Field
            </option>
            <option value="hidden">
                Hidden field
            </option>
            <option value="textarea">
                Text Area
            </option>
            <option value="checkbox">
                Checkbox list (multiple choices)
            </option>
            <option value="radio">
                Radio list
            </option>
            <option value="select">
                Select
            </option>
        </select>
    </div>

    <div class="row"
        v-show="current_question.type == 'input'">
        <label for="question_validate">
            Validation
        </label>
        <select class="validate"
                v-model="current_question.validate"
                id="question_validate">

            <option value="">
                Don't validate
            </option>
            <option value="email">
                Email
            </option>
            <option value="numeric">
                Numeric value
            </option>
            <option value="postcode" >
                Postcode
            </option>
            <option value="regex">
                RegEx
            </option>
        </select>
    </div>

    <div class="row regexRow"
         :class="{
            'hidden' : hideRegex
         }">
        <label for="question_regex">
            Regex
        </label>
        <input type="text"
               id="question_regex"
               v-model="current_question.regex">
        <div class="hint el">
            <i class="fa fa-info-circle"></i>
            <div class="text">
                Regular expression must be valid. It does not require start and end
                delimiters. Use with caution, always test this.
            </div>
        </div>
    </div>
    <div class="row">
        <label for="question_required">
            Required?
        </label>
        <input type="checkbox"
               id="question_required"
               value="1"
               v-bind:true-value="1"
               v-model="current_question.required"/>
    </div>

    <div class="row"
         v-show="showPlaceholder">
        <label for="question_placeholder">
            Placeholder text
        </label>
        <input type="text"
               id="question_placeholder"
               v-model="current_question.placeholder">
    </div>

    <div class="row"
         v-show="showOptions">

        <label>Options</label>
        <div id="current_question_options"
             v-sortable-option
             class="sortable_options">

            <div class="row show"
                 :data-id="option.id"
                 v-bind:id="'rorder-' + option.id"
                 v-for="option in current_question.options">
                <label class="inline"
                       v-bind:for="'question_option_' + option.id">
                    <i class="fa fa-arrows-v"></i>
                </label>
                <input type="text"
                       v-model="option.value"
                       v-bind:id="'question_option_' + option.id"/>
                <button type="submit"
                        @click.prevent="removeOption(option.id)"
                        class="noBtn removeOption"
                        value="Remove Option">
                    <i class="fa fa-remove"></i>
                </button>
                <label style="display: block; clear: both; margin-left:16%">Correct answer
                    <input type="checkbox"
                           v-bind:id="'question_' + option.id + '_correct'"
                           value="1"
                           v-bind:true-value="1"
                           v-model="option.correct"
                           style="margin-top: 3px; margin-right: 10px;" />
                </label>
            </div>
        </div>
        <label>&nbsp;</label>
        <button name="add_option"
                class="btn"
                @click.prevent="addNewOption()">
            Add another option
        </button>
    </div>

    <div class="row">
        <label for="notify">Notify</label>
        <input type="checkbox"
               id="notify"
               value="1"
               v-bind:true-value="1"
               v-model="current_question.notify"/>
        <div class="row">
            <div id="current_question_notifications">
                <div class="row show"
                     :data-id="notification.id"
                     v-for="notification in current_question.notifications"
                >
                    <label class="inline"
                           v-bind:for="'notication_email_' + notication.id">
                        E-mail
                    </label>
                    <input type="text"
                           v-model="notification.value"
                           v-bind:id="'notification_email_' + notification.id" />
                    <button type="submit"
                            @click.prevent="removeNotificationEmail(notification.id)"
                            class="noBtn removeNotification"
                            value="Remove Notification">
                        <i class="fa fa-remove"></i>
                    </button>
                </div>
            </div>
            <label></label>
            <button name="add_notification_email"
                    class="btn"
                    @click.prevent="addNewNotificationEmail()">
                Add another notification email
            </button>
        </div>
    </div>