Form builder module allows you to create forms on site from admin panel.

This is currently restricted to mtcadmin only.
Form creation allows to save time for form creation and processing as it has
a built in processing and validation mechanism.

## Installation ##
1. Clone the repository into `~/public_html/modules/FormBuilder`:
```
git clone https://USERNAME@bitbucket.org/mtcmedia/core-modules-formbuilder.git ~/public_html/modules/FormBuilder
```
2. Open site. Module loader will auto-install if necessary
3. When deploying to live please insure that `/modules/FormBuilder/admin/` is opened to ensure all DB sync is handled.

## Requirements ##

* Core 
* Requires Illuminate/database 5.2.*
  * For 5.1.* this will require change for ->pluck() usage.

## Usage ##

Used for creating forms with automated processing to reduce development time necessary for form setup.

1. Admin opens Form Builder section in Admin > MTC Only
2. New form can be created from the tabular navigation
3. Form name and basic settings are set for form (form name, button name and at least one callback are mandatory)
4. Question/Element can now be added
5. Each Form element needs at least name and type to be defined
6. At least one Fieldset needs to be created for site.
7. All Form Elements need to be arranged in Ordering section within fieldsets to display them
8. After all form elements are created and saved, this can be placed in site by calling the following hook
```php
{{ hooks_do_action('render_form', FORM_ID) }}
```

## Key Features ##

* intro text
* success text
* Form elements (questions) with multiple types:
  * Text field
  * Text area
  * Select
  * Radio list
  * Checkboxes
* Fieldsets with element ordering across fieldsets
* validation options & validation messages
* CSRF security generated and processed automatically
* Several form processing options:
  * save in DB
  * Send as an email
  * Callback to a class action
* Redirect after successful form submission
* Calling via hook
* Preview before saving

Wiki article: http://wiki.mtcmedia.co.uk/index.php?title=Form_Builder

Author: Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>