<?php

namespace Mtc\Modules\Members\Classes\Events;

use Mtc\Modules\Members\Models\Member;

/**
 * Class MemberLoggedInEvent
 *
 * This is an event class. Used to fire and handle when logged in member is fetched.
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author Martins Fridenbergs
 * @version 2016-11-12
 */
class MemberLoggedInEvent
{
    /**
     * @var Member
     */
    protected $member;

    /**
     * @return Member
     */
    public function getMember()
    {
        return $this->member;
    }


    /**
     * @param Member $member Currently logged in member
     */
    public function __construct(Member $member)
    {
        $this->member = $member;
    }
}