<?php
/**
 *  MemberOauthProviders Model
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017.02.10
 */
namespace Mtc\Modules\Members\Classes;

use Illuminate\Database\Eloquent\Model;
use Mtc\Modules\Members\Models\Member;

/**
 *  MemberOauthProviders Model
 *
 * Class that provides 3rd party authenticators for Members
 *
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 * @version 2017.02.10
 */
class MemberOauthProviders extends Model
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'member_oauth_providers';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'provider',
        'key'
    ];

    /**
     * Relationship to Member
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function member()
    {
        return $this->belongsTo(Member::class, 'member_id');
    }

    /**
     * Sets login information based on 3rd party data
     */
    public function loginByOauth()
    {
        $_SESSION['member_email'] = $this->member->email;
        $_SESSION['member_password'] = $this->member->password;
        $_SESSION['oauth_key'] = $this->key;
        $_SESSION['member_id'] = $this->member->id;
        $_SESSION['logged_in'] = true;
    }
}
