<?php

use Mtc\Modules\Members\Classes\Auth;
use Mtc\Plugins\MembersMessaging\Classes\Thread;

$path = "../../../";
require_once $path . "core/includes/header.inc.php";

$page_meta['title'] = config('app.name') . ' Messages';

if (!Auth::isLoggedIn()) {
    header("Location: " . route('members-login'));
    exit();
}

$threads = Thread::scopeForUser($member->id);

$email_history = \App\CustomerEmailHistory::query()
    ->where('email', $member->email)
    ->latest()
    ->get();

echo $twig->render('members/messages.twig', [
    'page_meta' => $page_meta,
    'threads' => $threads,
    'email_history' => $email_history,
]);
