<?php

use Illuminate\Support\Facades\Route;
use Mtc\Modules\Members\Http\Controllers\AuthController;
use Mtc\Modules\Members\Http\Controllers\MembersController;


Route::group([
    'prefix' => 'members',
], function () {
    Route::get('login', [AuthController::class, 'login'])
        ->name('members-login');
    Route::post('login', [AuthController::class, 'loginAction'])
        ->name('members-login-action');
    Route::get('register', [AuthController::class, 'register'])
        ->name('members-register');
    Route::post('register', [AuthController::class, 'registerAction'])
        ->name('members-register-action');
    Route::get('password-reminder', [AuthController::class, 'passwordReminder'])
        ->name('members-password-reminder');
    Route::post('password-reminder', [AuthController::class, 'passwordReminderAction'])
        ->name('members-password-reminder-action');
    Route::get('reset-password', [AuthController::class, 'resetPassword'])
        ->name('members-reset-password');
    Route::post('reset-password', [AuthController::class, 'resetPasswordAction'])
        ->name('members-reset-password-action');

    Route::get('dashboard', [MembersController::class, 'index'])
        ->name('members-dashboard');
    Route::get('orders', [MembersController::class, 'orders'])
        ->name('members-orders');
    Route::get('order/{id}', [MembersController::class, 'order'])
        ->name('members-order');
    Route::get('reorder/{id}', [MembersController::class, 'reorder'])
        ->name('members-reorder');
    Route::get('logout', [MembersController::class, 'logout'])
        ->name('members-logout');
    Route::get('account', [MembersController::class, 'account'])
        ->name('members-account');
    Route::post('account', [MembersController::class, 'accountStore'])
        ->name('members-account-store');
    Route::get('health-profile', [MembersController::class, 'healthProfile'])
        ->name('members-health-profile');
    Route::post('health-profile', [MembersController::class, 'healthProfileStore'])
        ->name('members-health-profile-store');
});

Route::any('member/log-in-as-member/{member_id}', [
    'as' => 'members-log-in-as-member',
    'uses' => 'Mtc\Modules\Members\Http\Controllers\MembersController@log_in_as_member',
]);

Route::get('member/referred', [
    'as' => 'members-referred',
    'uses' => 'Mtc\Modules\Members\Http\Controllers\MembersController@referred_members',
]);

Route::any('member/orders/nhs-prescriptions/data', [
    'as' => 'members-orders-nhs-prescriptions-data',
    'uses' => 'Mtc\Modules\Members\Http\Controllers\MembersController@get_prescription_data',
]);

Route::get('member/orders/nhs-prescriptions', [
    'as' => 'members-orders-nhs-prescriptions',
    'uses' => 'Mtc\Modules\Members\Http\Controllers\MembersController@orders__nhs_prescriptions',
]);


Route::get('member/orders/subscriptions', [
    'as' => 'members-orders-subscriptions',
    'uses' => 'Mtc\Modules\Members\Http\Controllers\MembersController@orders__subscriptions',
]);

Route::post('member/orders/subscription/{subscription_id?}', [
    'as' => 'members-orders-subscription',
    'uses' => 'Mtc\Modules\Members\Http\Controllers\MembersController@orders__subscription_update',
]);

Route::get('member/orders/subscription/edit/{subscription_id}', [
    'as' => 'members-orders-subscription-edit',
    'uses' => 'Mtc\Modules\Members\Http\Controllers\MembersController@orders__subscription_edit',
]);