<?php

define('MODEL_CLASS_NAME', 'stdClass'); // required

define('MODEL_SINGULAR', 'module'); // lowercase

define('MODEL_MODULE_DESCRIPTION', "
<p>Once you click save - a class shall be created; table shall be inserted; module
shall be generated; menu entry inserted - and you shall be redirected to it.
<b>Mind the Eloquent naming convention!</b> If you enter values for an already
existing module - some of its files shall be updated.</p>");

// Form setup and data validation options for edit.php
$model_form = array(
    'class_name' => array(
        'label' => 'Class Name',
        'rules' => array(
            'required' => true,
            'notEmpty' => true,
        ),
        'placeholder' => 'Event / PageComment',
        'info' => 'Camel case & singular. Example: "JobType"',
        'fieldset' => 'Fieldset:Module Setup'
    ),
    'table_name' => array(
        'label' => 'DB Table Name',
        'rules' => array(
            'required' => true,
            'notEmpty' => true,
        ),
        'placeholder' => 'events / page_comments',
        'info' => 'Words separated with "_". Has to be in plural. Example: "job_types"',
        'fieldset' => 'Fieldset:Module Setup'
    ),
    'module_folder_name_singular' => array(
        'label' => 'Lowercase Model Name In Singular',
        'rules' => array(
            'required' => true,
            'notEmpty' => true,
        ),
        'placeholder' => 'event / page comment',
        'info' => 'For example: "job type"',
        'fieldset' => 'Fieldset:Module Setup'
    ),
    'module_folder_name_plural' => array(
        'label' => 'Lowercase Model Name In Plural',
        'rules' => array(
            'required' => true,
            'notEmpty' => true,
        ),
        'placeholder' => 'events / page comments',
        'info' => 'For example: "job types"',
        'fieldset' => 'Fieldset:Module Setup'
    ),
    'create_menu_entry' => array(
        'label' => 'Create Menu Entry',
        'type' => 'checkbox',
        'fieldset' => 'Fieldset:Module Setup',
        'info' => 'May not produce correct links if advanced options are used.'
    ),
    'admin_panel_root' => array(
        'label' => 'Admin Panel Root',
        'type' => 'input',
        'class' => 'advanced-setup',
        'info' => 'Relatvie path expcted. By default admin panel root is ../../../modules/{CLASS_NAME}/admin',
        'placeholder' => '../../../modules/Event/admin / ../../../modules/PageComment/admin',
        'fieldset' => 'Fieldset:advanced',
        'rules'=> array(
            'regex' => '/^[^*?"<>|:]*$/'
        ),
    ),
    'model_class_location' => array(
        'label' => 'Model Class Location',
        'type' => 'input',
        'class' => 'advanced-setup',
        'info' => 'Relatvie path expcted. By default it is ../../../modules/{CLASS_NAME}/Classes',
        'placeholder' => '../../../modules/Event/Classes / ../../../modules/PageComment/Classes',
        'fieldset' => 'Fieldset:advanced',
        'rules'=> array(
            'regex' => '/^[^*?"<>|:]*$/'
        ),
    ),
    'model_namespace' => array(
        'label' => 'Model Class Namespace',
        'type' => 'input',
        'class' => 'advanced-setup',
        'info' => 'By default it is Mtc\Modules\{CLASS_NAME}\Classes',
        'placeholder' => 'Mtc\Modules\Event\Classes / Mtc\Modules\PageComment\Classes',
        'fieldset' => 'Fieldset:advanced',
        'rules'=> array(
            'regex' => '/^[^*?"<>|:]*$/'
        ),
    ),
    'module_helper_class_namespace' => array(
        'label' => 'Existing ModuleHelper Namespace',
        'type' => 'input',
        'class' => 'advanced-setup',
        'placeholder' => 'Mtc\Modules\ModuleBuilder\Classes\\',
        'info' => 'Mtc\Modules\ModuleBuilder\Classes\\',
        'fieldset' => 'Fieldset:advanced',
        'rules'=> array(
            'regex' => '/^[^*?"<>|:]*$/'
        ),
    ),
    'module_actions_class_namespace' => array(
        'label' => 'Existing ModuleActions Namespace',
        'type' => 'input',
        'class' => 'advanced-setup',
        'placeholder' => 'Mtc\Modules\ModuleBuilder\Classes\\',
        'info' => 'Mtc\Modules\ModuleBuilder\Classes\\',
        'fieldset' => 'Fieldset:advanced',
        'rules'=> array(
            'regex' => '/^[^*?"<>|:]*$/'
        ),
    ),
    'Fieldset:advanced' => array(
        'type'      => 'fieldset',
        'label'     => 'Advanced (Optional)',
        'closed'    => true, // Default: false
    ),
    'action' => array(
        'value' => 'update',
        'type' => 'hidden',
        'fieldset' => 'Fieldset:buttons'
    ),
    'submit' => array(
        'value' => 'Save',
        'type' => 'submit',
        'label' => "",
        'fieldset' => 'Fieldset:buttons'
    ),
    'Fieldset:buttons' => [
        'type' => 'fieldset',
        'hide_label' => true
    ]
);
