<?php
/**
 * @author: Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 * @version: 30.05.2018
 */

use \Mtc\Plugins\AccountVerifier\Classes\AccountVerifierSettings;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

$errors = [];
$messages = [];

$page_meta['title'] = 'Site Settings';

if (filter_input(INPUT_POST, 'action') === 'update') {
    AccountVerifierSettings::query()->truncate();
    AccountVerifierSettings::query()->insert([
        [
            'code' => 'enable_email_verification',
            'value' => (int)($_REQUEST['enable_email_verification'] ?? null),
        ],
        [
            'code' => 'enable_phone_verification',
            'value' => (int)($_REQUEST['enable_phone_verification'] ?? null),
        ],
    ]);
    header('refresh: 0');
    exit;
}

$twig->display('AccountVerifier/admin/settings.twig', [
    'page_meta' => $page_meta,
    'errors' => $errors,
    'request' => $_REQUEST,
    'messages' => $messages,
    'account_verifier_settings' => AccountVerifierSettings::all()->keyBy('code'),

]);
