<?php
/**
 * @author: Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 * @version: 25.05.2018
 */

use \Mtc\Plugins\AccountVerifier\Classes\AccountVerifier;

header('Content-Type: application/json');

$path = '../../';
require_once $path . 'core/includes/header.inc.php';

$errors = [];
$messages = [];
$status = 'ok';

$account_verifier = new AccountVerifier();
$type = filter_input(INPUT_POST, 'type');
$target = trim(filter_input(INPUT_POST, 'target'));
$code = filter_input(INPUT_POST, 'code');
$validation_object = ($type === 'email' ? 'Email address' : 'Phone number');

if (filter_input(INPUT_POST, 'action') === 'send_code') {
    if (!empty($target)) {
        if ($type === 'email') {
            if (AccountVerifier::emailVerified($target)) {
                $messages['account_verifier']['email']['sent'] = 'Your email has already been verified!';
                $status = 'verified';
            } else {
                $account_verifier->sendVerificationEmail($member, $target);
                if (empty($account_verifier->error)) {
                    $messages['account_verifier']['email']['sent'] = 'Please check your mailbox for verification code';
                } else {
                    $errors['info']['email'] = $account_verifier->error;
                }
            }
        } else {
            if (AccountVerifier::phoneVerified($target)) {
                $messages['account_verifier']['phone']['sent'] = 'Your phone number has already been verified!';
                $status = 'verified';
            } else {
                $account_verifier->sendVerificationSMS($member, $target);
                if (empty($account_verifier->error)) {
                    $messages['account_verifier']['phone']['sent'] = 'Please check your phone for verification code';
                } else {
                    $errors['info']['contact_no'] = $account_verifier->error;
                }
            }
        }
    } else {
        if ($type === 'email') {
            $errors['info']['email'] = 'Please specify your ' . $validation_object;
        } else {
            $errors['info']['contact_no'] = 'Please specify your ' . $validation_object;
        }
    }

} elseif (filter_input(INPUT_POST, 'action') === 'verify') {
    if (!empty($code)) {
        if (!$account_verification = $account_verifier->verifyCode($code, $member)) {
            $errors['account_verifier'][$type] = $validation_object . ' validation failed. Please try again.';
        } else {
            if ($type === 'email') {
                $messages['account_verifier']['email']['verified'] = 'Your email address has been verified!';
            } else {
                $messages['account_verifier']['phone']['verified'] = 'Your phone number has been verified!';
            }

        }
    } else {
        $errors[$type] = 'Please enter verification code';
    }
}

echo json_encode([
    'status' => empty($errors) ? $status : 'error',
    'errors' => $errors,
    'messages' => $messages,
]);