<?php
/**
 * Australia Post API Plugin install-script
 *
 * @author: Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 * @version: 23.04.2018
 */
namespace Mtc\Plugins\AustraliaPost\Classes;

use Mtc\Core\Setting;
use DateTime;

$data = [
    [
        'key'         => 'ACCOUNT_VERIFIER',
        'type'        => 'bool',
        'value'       => 1,
        'module'      => 'ACCOUNT_VERIFIER',
        'description' => 'Account Verifier plugin global enable setting',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'VERIFY_EMAIL',
        'type'        => 'bool',
        'value'       => 0,
        'module'      => 'ACCOUNT_VERIFIER',
        'description' => 'Whether the email should be verified during the checkout',
        'created_at'  => new DateTime(),
    ],
    [
        'key'         => 'VERIFY_SMS',
        'type'        => 'bool',
        'value'       => 0,
        'module'      => 'ACCOUNT_VERIFIER',
        'description' => 'Whether the phone number should be verified during the checkout',
        'created_at'  => new DateTime(),
    ],
];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

Setting::query()->insert($data);

$source = __DIR__ . '/20180525-1-AccountVerifyInstall.php';
$destination = SITE_PATH . '/migrations/20180525-1-AccountVerifyInstall.php';

// Copy the migration file over to migrations dir
if (!file_exists($destination)) {
    copy($source, $destination);

    exec('/usr/local/bin/php ' . SITE_PATH . '/migrations.php');
}