<?php

namespace Mtc\Plugins\Clinic\Src;

use Carbon\Carbon;
use Illuminate\Support\Collection;
use Mtc\Modules\Members\Models\MemberNote;

class Flag
{
    /**
     * Gets all patient flags
     *
     * @param $patientID
     * @return Collection
     */
    public static function getPatientFlags($patientID): Collection
    {
        $patientFlags =  MemberNote::query()
            ->with('admin_user')
            ->where('member_id', $patientID)
            ->where('is_flag', true)
            ->latest()
            ->get();

        $mergedFlags = self::getPatientSystemFlags()
            ->merge($patientFlags);

        return $mergedFlags->map(function ($note) {
            $note->author = '';
            if (!empty($note->system)) {
                $note->author = 'System';
            } else {
                $note->datetime = Carbon::parse($note->created_at)->format('d.m.Y H:i');
                if (!empty($note->admin_user)) {
                    $note->author = $note->admin_user->name;
                }
            }
            if (!empty($note->flag_due)) {
                $note->flagColour = 'blue';
                if ($note->flag_due === Carbon::now()->format('Y-m-d')) {
                    $note->flagColour = 'yellow';
                } elseif ($note->flag_due < Carbon::now()->format('Y-m-d')) {
                    $note->flagColour = 'red';
                }
                $note->flagDue = Carbon::parse($note->flag_due)->format('d/m/Y');
            }

            return $note;
        });
    }

    /**
     * Gets patient system flags
     *
     * @return Collection
     */
    public static function getPatientSystemFlags(): Collection
    {
        return collect([
            (object)[
                'content' => 'This is an example system flag',
                'system' => true,
            ]
        ]);
    }
}