Vue.component('addPatientNote', {

    props: [
        'routes',
        'addNote',
        'params',
    ],

    data: function() {
        return {
            loading: false,
            errors: {},
        };
    },

    mounted: function() {
        this.init();
    },

    methods: {
        init() {

        },
        cancel() {
            $('.overlayCloseButton').trigger('click');
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.loading = true;

            let orderID = null;

            if (typeof this.params !== 'undefined' && typeof this.params.orderID !== 'undefined') {
                orderID = this.params.orderID;
            }

            let vm = this;

            this.$http.post(this.routes['admin-member-notes-store'], {
                note: tinyMCE.get('patientNotesInput').getContent(),
                orderID: orderID,
            })
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    vm.emitEvent('newNoteAdded');
                    $('.overlayCloseButton').trigger('click');
                });
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
