const defaultTreatment = {
    id: null,
    item_id: null,
    date_from: '',
    date_to: '',
    product: '',
    notes: '',
};

Vue.component('editPatientTreatment', {

    props: [
        'routes',
        'editTreatment',
        'treatmentData',
    ],

    data: function() {
        return {
            treatment: defaultTreatment,
            loading: false,
            errors: {},
            foundItems: [],
            itemQuery: '',
            product: null,
            deletePrompt: false,
        };
    },

    mounted: function() {
        this.init();
    },

    watch: {
        treatmentData(treatment) {
            if (typeof treatment.id !== 'undefined') {
                this.treatment = treatment;
                this.product = treatment.item;
                this.deletePrompt = false;
                $('#treatmentDateFrom').val(treatment.date_from);
                $('#treatmentDateTo').val(treatment.date_to);
            }
        }
    },

    methods: {
        init() {

        },
        cancel() {
            $('.overlayCloseButton').trigger('click');
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.loading = true;

            this.treatment.item_id = this.product.id;
            this.treatment.size_id = this.product.size_id;
            this.treatment.date_from = $('#treatmentDateFrom').val();
            this.treatment.date_to = $('#treatmentDateTo').val();

            let vm = this;

            this.$http.post(this.routes['admin-patient-treatments-store'], this.treatment)
                .then((response) => {

                    this.loading = false;
                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        return;
                    }
                    vm.emitEvent('treatmentSaved');
                    $('.overlayCloseButton').trigger('click');
                });
        },
        searchItems: function () {
            let vm = this;
            this.$http.post(this.routes['admin-products-search'], {
                query: this.itemQuery,
            }).then(function (response) {
                if (response.data.success) {
                    vm.foundItems = response.data.items;
                    return;
                }
                vm.errors = response.data.errors;
            });
        },
        selectItem: function (item) {
            this.$set(this, 'product', item);
            this.clearItemSearch();
            $('#itemQuery').focus();
        },
        clearItemSearch: function() {
            this.itemQuery = '';
            this.foundItems = [];
        },
        resetProduct() {
            this.product = null;
        },
        deleteAction() {
            if (!this.deletePrompt) {
                this.deletePrompt = true;
                return;
            }
            this.deleteTreatment();
        },
        deleteTreatment() {
            this.loading = true;
            let vm = this;
            this.$http.post(this.routes['admin-patient-treatments-delete'], this.treatment)
                .then((response) => {
                    this.loading = false;
                    vm.emitEvent('treatmentDeleted');
                    $('.overlayCloseButton').trigger('click');
                });
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
