function simpleTinymceNew(el, options) {

    let settings = {
        content_css : "/core/css/tiny_mce.css",

        // General options
        theme : "modern",

        plugins: [
            "advlist autolink lists link image charmap print preview anchor",
            "searchreplace visualblocks code fullscreen",
            "insertdatetime media table contextmenu paste"
        ],

        menubar : false,
        statusbar : false,
        convert_fonts_to_spans : true,
        paste_as_text: true,
        relative_urls : false,
        remove_script_host : false,
        convert_urls : true,
        body_class: "wysiwigContent",
        width: 476,
        height: 150,
        resize: "both",
        image_dimensions: false,
        image_advtab: false,

        style : "float:left",
        advlist_bullet_styles: 'Default',
        advlist_number_styles: 'Default',
        style_formats: [
            {
                title: "Headers",
                items: [
                    {
                        title: "Header 2",
                        format: "h2"
                    },
                    {
                        title: "Header 3",
                        format: "h3"
                    },
                    {
                        title: "Header 4",
                        format: "h4"
                    },
                    {
                        title: "Header 5",
                        format: "h5"
                    },
                    {
                        title: "Header 6",
                        format: "h6"
                    }
                ]
            },
            {
                title: "Inline",
                items: [
                    {
                        title: "Bold",
                        icon: "bold",
                        format: "bold"
                    },
                    {
                        title: "Italic",
                        icon: "italic",
                        format: "italic"
                    },
                    {
                        title: "Underline",
                        icon: "underline",
                        format: "underline"
                    }
                ]
            },
            {
                title: "Blocks",
                items: [
                    {
                        title: "Paragraph",
                        format: "p"
                    },
                    {
                        title: "Blockquote",
                        format: "blockquote"
                    }
                ]
            }
        ],
        toolbar: "styleselect | bold italic | bullist numlist | link unlink",
        contextmenu: "link image inserttable | cell row column deletetable code"

    };

    // Overwrite default setting values
    if (typeof options !== 'undefined') {
        Object.keys(options).forEach(key => {
            const value = options[key];
            settings[key] = options[key];
        });
    }

    el.tinymce(settings);
}